/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.screen.model.StandardEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityEquipmentCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityGeneralCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntitySpawnSettingsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityVillagerTradeCategoryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;

public class EntityEditorModel
extends StandardEditorModel {
    public EntityEditorModel(EntityEditorContext context) {
        super(context);
    }

    public EntityEditorContext getContext() {
        return (EntityEditorContext)super.getContext();
    }

    @Override
    public void save() {
        boolean hadPermission = this.getContext().hasPermission();
        super.save();
        if (hadPermission && this.getContext().hasPermission()) {
            ClientUtil.showMessage((Component)ModTexts.Messages.successUpdate(ModTexts.ENTITY));
        }
    }

    @Override
    protected void setupCategories() {
        this.getCategories().add(new EntityGeneralCategoryModel(this));
        Entity entity = this.getContext().getEntity();
        if (entity instanceof LivingEntity) {
            this.getCategories().add(new EntityEquipmentCategoryModel(this));
        }
        if (entity instanceof Mob) {
            this.getCategories().add(new EntitySpawnSettingsCategoryModel(this));
        }
        if (entity instanceof Villager) {
            this.getCategories().add(new EntityVillagerTradeCategoryModel(this));
        }
    }
}

