/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.EntityEquipmentEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EntityEquipmentCategoryModel
extends EntityCategoryModel {
    private static final String HAND_ITEMS_TAG = "HandItems";
    private static final String HAND_DROPS_TAG = "HandDropChances";
    private static final String ARMOR_ITEMS_TAG = "ArmorItems";
    private static final String ARMOR_DROPS_TAG = "ArmorDropChances";
    public static final float DEFAULT_DROP_CHANCE = 0.085f;
    public static final float DROP_EPSILON = 1.0E-4f;
    private final List<EntityEquipmentEntryModel> equipmentEntries = new ArrayList<EntityEquipmentEntryModel>();

    public EntityEquipmentCategoryModel(EntityEditorModel editor) {
        super((Component)ModTexts.ENTITY_EQUIPMENT, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().clear();
        this.equipmentEntries.clear();
        for (Slot slot : Slot.values()) {
            ItemStack stack = this.readItem(slot);
            float dropChance = this.readDropChance(slot);
            EntityEquipmentEntryModel entry = new EntityEquipmentEntryModel(this, slot, stack, dropChance);
            this.equipmentEntries.add(entry);
            this.getEntries().add(entry);
        }
    }

    private ItemStack readItem(Slot slot) {
        CompoundTag data = this.getData();
        if (!data.contains(slot.itemListTag, 9)) {
            return ItemStack.EMPTY;
        }
        ListTag list = data.getList(slot.itemListTag, 10);
        if (slot.index >= list.size()) {
            return ItemStack.EMPTY;
        }
        Tag tag = list.get(slot.index);
        if (!(tag instanceof CompoundTag)) {
            return ItemStack.EMPTY;
        }
        CompoundTag compound = (CompoundTag)tag;
        return ItemStack.parseOptional((HolderLookup.Provider)ClientUtil.registryAccess(), (CompoundTag)compound);
    }

    private float readDropChance(Slot slot) {
        CompoundTag data = this.getData();
        if (!data.contains(slot.dropChanceListTag, 9)) {
            return slot.defaultDropChance;
        }
        ListTag list = data.getList(slot.dropChanceListTag, 5);
        if (slot.index >= list.size()) {
            return slot.defaultDropChance;
        }
        Tag tag = list.get(slot.index);
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return floatTag.getAsFloat();
        }
        return slot.defaultDropChance;
    }

    @Override
    public void apply() {
        super.apply();
        this.writeToTag();
    }

    private void writeToTag() {
        ListTag handItems = new ListTag();
        ListTag handDropChances = new ListTag();
        ListTag armorItems = new ListTag();
        ListTag armorDropChances = new ListTag();
        boolean hasHandItems = false;
        boolean hasArmorItems = false;
        boolean customHandDropChance = false;
        boolean customArmorDropChance = false;
        for (EntityEquipmentEntryModel entry : this.equipmentEntries) {
            Slot slot = entry.getSlot();
            CompoundTag itemTag = entry.getItemStack().is(Items.STICK) ? new CompoundTag() : entry.createItemTag();
            FloatTag dropTag = FloatTag.valueOf((float)entry.getDropChance());
            if (slot.isHand()) {
                handItems.add((Object)itemTag);
                handDropChances.add((Object)dropTag);
                if (!itemTag.isEmpty()) {
                    hasHandItems = true;
                }
                if (entry.isDefaultDropChance()) continue;
                customHandDropChance = true;
                continue;
            }
            armorItems.add((Object)itemTag);
            armorDropChances.add((Object)dropTag);
            if (!itemTag.isEmpty()) {
                hasArmorItems = true;
            }
            if (entry.isDefaultDropChance()) continue;
            customArmorDropChance = true;
        }
        CompoundTag data = this.getData();
        if (hasHandItems) {
            data.put(HAND_ITEMS_TAG, (Tag)handItems);
        } else {
            data.remove(HAND_ITEMS_TAG);
        }
        if (customHandDropChance && hasHandItems) {
            data.put(HAND_DROPS_TAG, (Tag)handDropChances);
        } else {
            data.remove(HAND_DROPS_TAG);
        }
        if (hasArmorItems) {
            data.put(ARMOR_ITEMS_TAG, (Tag)armorItems);
        } else {
            data.remove(ARMOR_ITEMS_TAG);
        }
        if (customArmorDropChance && hasArmorItems) {
            data.put(ARMOR_DROPS_TAG, (Tag)armorDropChances);
        } else {
            data.remove(ARMOR_DROPS_TAG);
        }
    }

    public String formatDropChance(float value) {
        return String.format(Locale.ROOT, "%.3f", Float.valueOf(value));
    }

    public static enum Slot {
        MAIN_HAND("HandItems", "HandDropChances", 0, true, () -> ModTexts.MAIN_HAND.copy()),
        OFF_HAND("HandItems", "HandDropChances", 1, true, () -> ModTexts.OFF_HAND.copy()),
        FEET("ArmorItems", "ArmorDropChances", 0, false, () -> ModTexts.FEET.copy()),
        LEGS("ArmorItems", "ArmorDropChances", 1, false, () -> ModTexts.LEGS.copy()),
        CHEST("ArmorItems", "ArmorDropChances", 2, false, () -> ModTexts.CHEST.copy()),
        HEAD("ArmorItems", "ArmorDropChances", 3, false, () -> ModTexts.HEAD.copy());

        private final String itemListTag;
        private final String dropChanceListTag;
        private final int index;
        private final boolean hand;
        private final Supplier<MutableComponent> labelSupplier;
        private final float defaultDropChance;

        private Slot(String itemListTag, String dropChanceListTag, int index, boolean hand, Supplier<MutableComponent> labelSupplier) {
            this(itemListTag, dropChanceListTag, index, hand, labelSupplier, 0.085f);
        }

        private Slot(String itemListTag, String dropChanceListTag, int index, boolean hand, Supplier<MutableComponent> labelSupplier, float defaultDropChance) {
            this.itemListTag = itemListTag;
            this.dropChanceListTag = dropChanceListTag;
            this.index = index;
            this.hand = hand;
            this.labelSupplier = labelSupplier;
            this.defaultDropChance = defaultDropChance;
        }

        public boolean isHand() {
            return this.hand;
        }

        public MutableComponent label() {
            return this.labelSupplier.get();
        }

        public float defaultDropChance() {
            return this.defaultDropChance;
        }
    }
}

