/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.TextEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EntityGeneralCategoryModel
extends EntityCategoryModel {
    private static final String HEALTH_TAG = "Health";
    private static final String ATTRIBUTES_TAG = "attributes";
    private static final String ATTRIBUTE_ID_TAG = "id";
    private static final String ATTRIBUTE_BASE_TAG = "base";
    private static final String MAX_HEALTH_ATTRIBUTE_ID = "minecraft:generic.max_health";

    public EntityGeneralCategoryModel(EntityEditorModel model) {
        super((Component)ModTexts.GENERAL, model);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().addAll((EntryModel[])new EntryModel[]{new FloatEntryModel((CategoryModel)this, ModTexts.HEALTH, this.getData().getFloat(HEALTH_TAG), this::setHealth), new TextEntryModel((CategoryModel)this, ModTexts.CUSTOM_NAME, this.getCustomName(), this::setCustomName), new BooleanEntryModel((CategoryModel)this, ModTexts.ALWAYS_SHOW_NAME, this.getData().getBoolean("CustomNameVisible"), b -> this.putBooleanOrRemove("CustomNameVisible", (boolean)b)), new BooleanEntryModel((CategoryModel)this, ModTexts.INVULNERABLE, this.getData().getBoolean("Invulnerable"), b -> this.getData().putBoolean("Invulnerable", b.booleanValue())), new BooleanEntryModel((CategoryModel)this, ModTexts.SILENT, this.getData().getBoolean("Silent"), b -> this.putBooleanOrRemove("Silent", (boolean)b)), new BooleanEntryModel((CategoryModel)this, ModTexts.NO_GRAVITY, this.getData().getBoolean("NoGravity"), b -> this.putBooleanOrRemove("NoGravity", (boolean)b)), new BooleanEntryModel((CategoryModel)this, ModTexts.GLOWING, this.getData().getBoolean("Glowing"), b -> this.putBooleanOrRemove("Glowing", (boolean)b)), new IntegerEntryModel((CategoryModel)this, ModTexts.FIRE, this.getData().getShort("Fire"), s -> this.getData().putShort("Fire", s.shortValue()))});
    }

    private MutableComponent getCustomName() {
        String s = this.getData().getString("CustomName");
        if (s.isEmpty()) {
            return null;
        }
        MutableComponent component = Component.Serializer.fromJson((String)s, (HolderLookup.Provider)ClientUtil.registryAccess());
        return component == null ? null : component.copy();
    }

    private void setCustomName(MutableComponent value) {
        if (value != null && !value.getString().isEmpty()) {
            this.getData().putString("CustomName", Component.Serializer.toJson((Component)value, (HolderLookup.Provider)ClientUtil.registryAccess()));
        } else if (this.getData().getString("CustomName").isEmpty()) {
            this.getData().remove("CustomName");
        } else {
            this.getData().putString("CustomName", "");
        }
    }

    private void putBooleanOrRemove(String tagName, boolean value) {
        if (value) {
            this.getData().putBoolean(tagName, true);
        } else {
            this.getData().remove(tagName);
        }
    }

    private void setHealth(float health) {
        this.getData().putFloat(HEALTH_TAG, health);
        this.updateMaxHealthAttribute(health);
    }

    private void updateMaxHealthAttribute(float health) {
        CompoundTag data = this.getData();
        ListTag attributes = data.getList(ATTRIBUTES_TAG, 10);
        CompoundTag maxHealthAttribute = null;
        for (int i = 0; i < attributes.size(); ++i) {
            CompoundTag attribute = attributes.getCompound(i);
            if (!MAX_HEALTH_ATTRIBUTE_ID.equals(attribute.getString(ATTRIBUTE_ID_TAG))) continue;
            maxHealthAttribute = attribute;
            break;
        }
        if (maxHealthAttribute == null) {
            maxHealthAttribute = new CompoundTag();
            maxHealthAttribute.putString(ATTRIBUTE_ID_TAG, MAX_HEALTH_ATTRIBUTE_ID);
            attributes.add((Object)maxHealthAttribute);
        }
        maxHealthAttribute.putDouble(ATTRIBUTE_BASE_TAG, (double)health);
        data.put(ATTRIBUTES_TAG, (Tag)attributes);
    }
}

