/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class EntitySpawnSettingsCategoryModel
extends EntityCategoryModel {
    public EntitySpawnSettingsCategoryModel(EntityEditorModel editor) {
        super((Component)ModTexts.ENTITY_SPAWN, editor);
    }

    @Override
    protected void setupEntries() {
        CompoundTag data = this.getData();
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.CAN_PICK_UP_LOOT, data.getBoolean("CanPickUpLoot"), value -> this.setBoolean("CanPickUpLoot", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.PERSISTENCE_REQUIRED, data.getBoolean("PersistenceRequired"), value -> this.setBoolean("PersistenceRequired", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.NO_AI, data.getBoolean("NoAI"), value -> this.setBoolean("NoAI", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LEFT_HANDED, data.getBoolean("LeftHanded"), value -> this.setBoolean("LeftHanded", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.CAN_JOIN_RAID, data.getBoolean("CanJoinRaid"), value -> this.setBoolean("CanJoinRaid", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.PATROL_LEADER, data.getBoolean("PatrolLeader"), value -> this.setBoolean("PatrolLeader", (boolean)value)));
        String team = data.contains("Team", 8) ? data.getString("Team") : "";
        this.getEntries().add(new StringEntryModel((CategoryModel)this, ModTexts.TEAM, team, this::setTeam));
        float reinforcements = data.contains("SpawnReinforcementsChance", 5) ? data.getFloat("SpawnReinforcementsChance") : 0.0f;
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, ModTexts.SPAWN_REINFORCEMENTS_CHANCE, reinforcements, this::setSpawnReinforcementsChance, value -> value.floatValue() >= 0.0f && value.floatValue() <= 1.0f));
    }

    private void setBoolean(String key, boolean value) {
        if (value) {
            this.getData().putBoolean(key, true);
        } else {
            this.getData().remove(key);
        }
    }

    private void setTeam(String value) {
        String trimmed;
        String string = trimmed = value == null ? "" : value.trim();
        if (trimmed.isEmpty()) {
            this.getData().remove("Team");
        } else {
            this.getData().putString("Team", trimmed);
        }
    }

    private void setSpawnReinforcementsChance(float value) {
        float clamped = Math.max(0.0f, Math.min(1.0f, value));
        if (clamped > 0.0f) {
            this.getData().putFloat("SpawnReinforcementsChance", clamped);
        } else {
            this.getData().remove("SpawnReinforcementsChance");
        }
    }
}

