/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoodComponentState {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean enabled;
    private boolean hasEverBeenEnabled;
    private int nutrition = 4;
    private float saturation = 0.3f;
    private boolean alwaysEat;
    private float eatSeconds = 1.6f;
    private String usingConvertsToId = "";
    private Optional<ItemStack> originalUsingConvertsTo = Optional.empty();
    private List<FoodProperties.PossibleEffect> effects = new ArrayList<FoodProperties.PossibleEffect>();

    public void loadFrom(ItemStack stack) {
        FoodProperties properties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (properties != null) {
            this.hasEverBeenEnabled = true;
            this.setEnabled(true);
            this.nutrition = properties.nutrition();
            this.saturation = properties.saturation();
            this.alwaysEat = properties.canAlwaysEat();
            this.eatSeconds = properties.eatSeconds();
            this.originalUsingConvertsTo = properties.usingConvertsTo().map(ItemStack::copy);
            this.usingConvertsToId = this.originalUsingConvertsTo.map(ItemStack::getItem).map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).orElse("");
            this.effects = new ArrayList<FoodProperties.PossibleEffect>(properties.effects());
            LOGGER.info("Loaded food component for {} -> converts_to='{}' preservedStack={}", (Object)this.describeStack(stack), (Object)this.usingConvertsToId, (Object)this.originalUsingConvertsTo.map(this::describeStack).orElse("<empty>"));
        } else {
            this.hasEverBeenEnabled = false;
            this.setEnabled(false);
            this.nutrition = 4;
            this.saturation = 0.3f;
            this.alwaysEat = false;
            this.eatSeconds = 1.6f;
            this.originalUsingConvertsTo = Optional.empty();
            this.usingConvertsToId = "";
            this.effects = new ArrayList<FoodProperties.PossibleEffect>();
            LOGGER.info("Food component not present on {}. State reset.", (Object)this.describeStack(stack));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.hasEverBeenEnabled = true;
        }
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(int nutrition) {
        this.nutrition = Math.max(0, nutrition);
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = Math.max(0.0f, saturation);
    }

    public boolean isAlwaysEat() {
        return this.alwaysEat;
    }

    public void setAlwaysEat(boolean alwaysEat) {
        this.alwaysEat = alwaysEat;
    }

    public float getEatSeconds() {
        return this.eatSeconds;
    }

    public void setEatSeconds(float eatSeconds) {
        this.eatSeconds = Math.max(0.1f, eatSeconds);
    }

    public String getUsingConvertsToId() {
        return this.usingConvertsToId;
    }

    public void setUsingConvertsToId(String usingConvertsToId) {
        this.usingConvertsToId = usingConvertsToId == null ? "" : usingConvertsToId.trim();
    }

    public void prepareForInitialEnable(ItemStack stack) {
        if (this.hasEverBeenEnabled) {
            return;
        }
        this.setNutrition(0);
        this.setSaturation(0.0f);
        this.setAlwaysEat(true);
        this.setEatSeconds(1.6f);
        this.usingConvertsToId = "";
        this.originalUsingConvertsTo = Optional.empty();
        LOGGER.info("Prepared initial food state for {} -> converts_to cleared", (Object)this.describeStack(stack));
    }

    public List<FoodProperties.PossibleEffect> getEffects() {
        return List.copyOf(this.effects);
    }

    public void setEffects(List<FoodProperties.PossibleEffect> newEffects) {
        this.effects = new ArrayList<FoodProperties.PossibleEffect>(newEffects);
    }

    public Optional<ItemStack> resolveUsingConvertsTo() {
        if (this.usingConvertsToId.isBlank()) {
            LOGGER.info("resolveUsingConvertsTo skipped because id blank (state currently disabled?).");
            return Optional.empty();
        }
        ResourceLocation rl = ResourceLocation.tryParse((String)this.usingConvertsToId);
        if (rl == null) {
            LOGGER.warn("Failed to parse using_converts_to id '{}'", (Object)this.usingConvertsToId);
            return Optional.empty();
        }
        Item item = BuiltInRegistries.ITEM.getOptional(rl).orElse(null);
        if (item == null) {
            LOGGER.warn("Unknown using_converts_to item id '{}'", (Object)this.usingConvertsToId);
            return Optional.empty();
        }
        Optional<ItemStack> preserved = this.originalUsingConvertsTo.filter(stack -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).equals((Object)rl)).map(ItemStack::copy);
        if (preserved.isPresent()) {
            LOGGER.info("Reusing preserved using_converts_to stack: {}", (Object)this.describeStack(preserved.get()));
            return preserved;
        }
        ItemStack result = item.getDefaultInstance();
        if (result.isEmpty()) {
            result = new ItemStack((ItemLike)item);
        }
        ItemStack prepared = this.prepareConvertStack(result);
        LOGGER.info("Built new using_converts_to stack for '{}' -> {}", (Object)this.usingConvertsToId, (Object)this.describeStack(prepared));
        return Optional.of(prepared);
    }

    public List<FoodProperties.PossibleEffect> copyEffectsForComponent() {
        if (this.effects.isEmpty()) {
            return List.of();
        }
        return List.copyOf(this.effects);
    }

    public void updateOriginalUsingConvertsTo(Optional<ItemStack> stack) {
        this.originalUsingConvertsTo = stack.filter(s -> !s.isEmpty()).map(this::prepareConvertStack);
        LOGGER.info("Updated preserved using_converts_to stack to {}", (Object)this.originalUsingConvertsTo.map(this::describeStack).orElse("<empty>"));
    }

    private ItemStack prepareConvertStack(ItemStack source) {
        if (source.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack sanitized = new ItemStack((ItemLike)source.getItem());
        sanitized.setCount(1);
        sanitized.remove(DataComponents.FOOD);
        LOGGER.info("Sanitized convert stack -> {}", (Object)this.describeStack(sanitized));
        return sanitized;
    }

    private String describeStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return "<empty>";
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        StringBuilder builder = new StringBuilder(id.toString());
        builder.append(" x").append(stack.getCount());
        Component name = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (name != null) {
            builder.append(" name=\"").append(name.getString()).append("\"");
        }
        if (stack.get(DataComponents.FOOD) != null) {
            builder.append(" [has food]");
        }
        return builder.toString();
    }
}

