/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class ItemBannerPatternCategoryModel
extends ItemEditorCategoryModel {
    private String baseColorName = "white";
    private final List<StringEntryModel> layerEntries = new ArrayList<StringEntryModel>();

    public ItemBannerPatternCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.BANNER, editor);
    }

    @Override
    protected void setupEntries() {
        this.layerEntries.clear();
        ItemStack stack = this.getParent().getContext().getItemStack();
        DyeColor base = (DyeColor)stack.get(DataComponents.BASE_COLOR);
        if (base != null) {
            this.baseColorName = base.getName();
        }
        this.getEntries().add(new StringEntryModel((CategoryModel)this, ModTexts.BANNER_BASE_COLOR, this.baseColorName, value -> {
            this.baseColorName = value == null ? "" : value.trim();
        }));
        BannerPatternLayers layers = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
        if (layers != null) {
            layers.layers().forEach(layer -> this.getEntries().add(this.createLayerEntry(this.formatLayer((BannerPatternLayers.Layer)layer))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createLayerEntry("");
    }

    private EntryModel createLayerEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.BANNER_LAYER, spec, value -> {});
        this.layerEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        DyeColor base = DyeColor.byName((String)this.baseColorName, null);
        if (base != null) {
            stack.set(DataComponents.BASE_COLOR, (Object)base);
        } else {
            stack.remove(DataComponents.BASE_COLOR);
        }
        HolderLookup.RegistryLookup patternLookup = ClientUtil.registryAccess().lookup(Registries.BANNER_PATTERN).orElse(null);
        ArrayList<BannerPatternLayers.Layer> parsedLayers = new ArrayList<BannerPatternLayers.Layer>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.layerEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<BannerPatternLayers.Layer> parsed = this.parseLayer(spec, (HolderLookup.RegistryLookup<BannerPattern>)patternLookup);
            if (parsed.isPresent()) {
                parsedLayers.add(parsed.get());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedLayers.isEmpty()) {
            stack.remove(DataComponents.BANNER_PATTERNS);
        } else {
            stack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(parsedLayers));
        }
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:banner_patterns");
            components.remove("minecraft:base_color");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }

    private String formatLayer(BannerPatternLayers.Layer layer) {
        String patternId = layer.pattern().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("");
        return patternId + "|" + layer.color().getName();
    }

    private Optional<BannerPatternLayers.Layer> parseLayer(String spec, HolderLookup.RegistryLookup<BannerPattern> lookup) {
        String[] parts = spec.split("\\|", -1);
        if (parts.length < 2) {
            return Optional.empty();
        }
        ResourceLocation patternId = ResourceLocation.tryParse((String)parts[0].trim());
        if (patternId == null || lookup == null) {
            return Optional.empty();
        }
        Optional pattern = lookup.get(ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)patternId));
        if (pattern.isEmpty()) {
            return Optional.empty();
        }
        DyeColor color = DyeColor.byName((String)parts[1].trim().toLowerCase(Locale.ROOT), null);
        if (color == null) {
            return Optional.empty();
        }
        return Optional.of(new BannerPatternLayers.Layer((Holder)pattern.get(), color));
    }
}

