/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BlockSelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ItemStack;

public class ItemBlockListCategoryModel
extends ItemEditorCategoryModel {
    private final String tagName;
    private ListTag newBlocks;

    public ItemBlockListCategoryModel(Component name, ItemEditorModel editor, String tagName) {
        super(name, editor);
        this.tagName = tagName;
    }

    @Override
    protected void setupEntries() {
        ListTag nbtList = this.getTag().getList(this.tagName, 8);
        if (!nbtList.isEmpty()) {
            nbtList.stream().map(Tag::getAsString).map(this::createBlockEntry).forEach(this.getEntries()::add);
            return;
        }
        CompoundTag data = this.getData();
        if (data.contains("components", 10)) {
            CompoundTag comp;
            String key;
            CompoundTag components = data.getCompound("components");
            String string = key = "CanDestroy".equals(this.tagName) ? "minecraft:can_break" : "minecraft:can_place_on";
            if (components.contains(key, 10) && (comp = components.getCompound(key)).contains("predicates", 9)) {
                ListTag preds = comp.getList("predicates", 10);
                for (Tag predicateTag : preds) {
                    CompoundTag predicate;
                    if (!(predicateTag instanceof CompoundTag) || !(predicate = (CompoundTag)predicateTag).contains("blocks")) continue;
                    this.readComponentBlocks(predicate.get("blocks"));
                }
            }
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createBlockEntry("");
    }

    private EntryModel createBlockEntry(String id) {
        return new BlockSelectionEntryModel((CategoryModel)this, null, id, this::addBlock);
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.BLOCK;
    }

    @Override
    public void apply() {
        this.newBlocks = new ListTag();
        super.apply();
        if (!this.newBlocks.isEmpty()) {
            this.getOrCreateTag().put(this.tagName, (Tag)this.newBlocks);
        } else if (this.getOrCreateTag().contains(this.tagName)) {
            this.getOrCreateTag().remove(this.tagName);
        }
        ItemStack stack = this.getParent().getContext().getItemStack();
        ArrayList predicates = new ArrayList();
        Optional lookupOpt = ClientUtil.registryAccess().lookup(Registries.BLOCK);
        if (lookupOpt.isPresent()) {
            HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)lookupOpt.get();
            for (Tag t : this.newBlocks) {
                StringTag s;
                ResourceLocation rl;
                if (!(t instanceof StringTag) || (rl = ResourceLocation.tryParse((String)(s = (StringTag)t).getAsString())) == null) continue;
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)rl);
                Optional holder = lookup.get(key);
                holder.ifPresent(h -> predicates.add(new BlockPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{h})), Optional.empty(), Optional.empty())));
            }
        }
        AdventureModePredicate predicate = predicates.isEmpty() ? null : new AdventureModePredicate(predicates, true);
        boolean isDestroy = "CanDestroy".equals(this.tagName);
        if (predicate != null) {
            if (isDestroy) {
                stack.set(DataComponents.CAN_BREAK, (Object)predicate);
            } else {
                stack.set(DataComponents.CAN_PLACE_ON, (Object)predicate);
            }
        } else if (isDestroy) {
            stack.remove(DataComponents.CAN_BREAK);
        } else {
            stack.remove(DataComponents.CAN_PLACE_ON);
        }
    }

    private void addBlock(String id) {
        this.newBlocks.add((Object)StringTag.valueOf((String)id));
    }

    private void readComponentBlocks(Tag blocksTag) {
        if (blocksTag == null) {
            return;
        }
        if (blocksTag instanceof StringTag) {
            StringTag stringTag = (StringTag)blocksTag;
            this.addComponentBlock(stringTag.getAsString());
            return;
        }
        if (blocksTag instanceof ListTag) {
            ListTag listTag = (ListTag)blocksTag;
            for (Tag element : listTag) {
                this.readComponentBlocks(element);
            }
            return;
        }
        if (blocksTag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)blocksTag;
            if (compoundTag.contains("id", 8)) {
                this.addComponentBlock(compoundTag.getString("id"));
            }
            if (compoundTag.contains("tag", 8)) {
                this.addComponentBlock("#" + compoundTag.getString("tag"));
            }
            if (compoundTag.contains("blocks")) {
                this.readComponentBlocks(compoundTag.get("blocks"));
            }
        }
    }

    private void addComponentBlock(String id) {
        if (id != null && !id.isEmpty()) {
            this.getEntries().add(this.createBlockEntry(id));
        }
    }
}

