/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ItemBucketEntityCategoryModel
extends ItemEditorCategoryModel {
    private String currentData = "";
    private StringEntryModel dataEntry;

    public ItemBucketEntityCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.BUCKET_ENTITY, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        CustomData data = (CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA);
        this.currentData = data != null ? data.copyTag().toString() : "";
        this.dataEntry = new StringEntryModel((CategoryModel)this, ModTexts.BUCKET_ENTITY_DATA, this.currentData, value -> {
            this.currentData = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.dataEntry);
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (this.currentData.isBlank()) {
            stack.remove(DataComponents.BUCKET_ENTITY_DATA);
            this.dataEntry.setValid(true);
        } else {
            try {
                CompoundTag tag = TagParser.parseTag((String)this.currentData);
                stack.set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                this.dataEntry.setValid(true);
            }
            catch (Exception ex) {
                this.dataEntry.setValid(false);
            }
        }
    }
}

