/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ItemContainerCategoryModel
extends ItemEditorCategoryModel {
    private final List<StringEntryModel> slotEntries = new ArrayList<StringEntryModel>();

    public ItemContainerCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.CONTAINER_CONTENTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.slotEntries.clear();
        ItemStack stack = this.getParent().getContext().getItemStack();
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null) {
            contents.stream().filter(item -> !item.isEmpty()).forEach(item -> this.getEntries().add(this.createSlotEntry(this.formatSlot((ItemStack)item))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createSlotEntry("");
    }

    private EntryModel createSlotEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.CONTAINER_SLOT, spec, value -> {});
        this.slotEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        ArrayList<ItemStack> parsed = new ArrayList<ItemStack>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.slotEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<ItemStack> parsedStack = this.parseSlot(spec);
            if (parsedStack.isPresent()) {
                parsed.add(parsedStack.get());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsed.isEmpty()) {
            stack.remove(DataComponents.CONTAINER);
        } else {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(parsed));
        }
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:container");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }

    private Optional<ItemStack> parseSlot(String spec) {
        try {
            CompoundTag tag = TagParser.parseTag((String)spec);
            ItemStack parsed = ItemStack.parseOptional((HolderLookup.Provider)ClientUtil.registryAccess(), (CompoundTag)tag);
            if (parsed.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(parsed);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private String formatSlot(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.save(ClientUtil.registryAccess(), (Tag)new CompoundTag());
        return tag.toString();
    }
}

