/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ItemContainerSlotEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ItemContainerGridCategoryModel
extends ItemEditorCategoryModel {
    public ItemContainerGridCategoryModel(ItemEditorModel parent) {
        super((Component)ModTexts.CONTAINER_GRID, parent);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null) {
            contents.stream().forEach(item -> this.getEntries().add(new ItemContainerSlotEntryModel(this, (ItemStack)item)));
        }
    }

    @Override
    public boolean canAddEntryInList() {
        return true;
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return new ItemContainerSlotEntryModel(this, ItemStack.EMPTY);
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        ArrayList<ItemStack> collected = new ArrayList<ItemStack>();
        boolean anyNonEmpty = false;
        for (EntryModel entryModel : this.getEntries()) {
            if (!(entryModel instanceof ItemContainerSlotEntryModel)) continue;
            ItemContainerSlotEntryModel entry = (ItemContainerSlotEntryModel)entryModel;
            ItemStack slotStack = entry.getItemStack();
            ItemStack copy = slotStack.isEmpty() ? ItemStack.EMPTY : slotStack.copy();
            collected.add(copy);
            if (copy.isEmpty()) continue;
            anyNonEmpty = true;
        }
        if (!anyNonEmpty) {
            stack.remove(DataComponents.CONTAINER);
        } else {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(collected));
        }
    }
}

