/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ActionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ItemContainerSlotEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;

public class ItemCrossbowCategoryModel
extends ItemEditorCategoryModel {
    public ItemCrossbowCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.CROSSBOW, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        this.getEntries().add(new ActionEntryModel(this, (Component)ModTexts.gui("crossbow_projectile_help_button"), () -> ClientUtil.showMessage((Component)ModTexts.Messages.crossbowProjectileHelp())));
        ChargedProjectiles charged = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (charged != null && !charged.isEmpty()) {
            charged.getItems().forEach(item -> this.getEntries().add(new ItemContainerSlotEntryModel(this, (ItemStack)item)));
        }
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return new ItemContainerSlotEntryModel(this, ItemStack.EMPTY);
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        for (EntryModel entry : this.getEntries()) {
            ItemContainerSlotEntryModel projectile;
            ItemStack value;
            if (!(entry instanceof ItemContainerSlotEntryModel) || (value = (projectile = (ItemContainerSlotEntryModel)entry).getItemStack()).isEmpty()) continue;
            projectiles.add(value.copy());
        }
        if (projectiles.isEmpty()) {
            stack.remove(DataComponents.CHARGED_PROJECTILES);
        } else {
            stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(projectiles));
        }
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:charged_projectiles");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }
}

