/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ValueEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.EnchantmentEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ItemEnchantmentsCategoryModel
extends ItemEditorCategoryModel {
    private ListTag newEnch;

    public ItemEnchantmentsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.ENCHANTMENTS, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getStack();
        ItemEnchantments ench = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
        boolean any = false;
        if (ench != null && !ench.isEmpty()) {
            any = true;
            ench.entrySet().stream().map(this::createEnchantment).forEach(this.getEntries()::add);
        }
        if (stored != null && !stored.isEmpty()) {
            any = true;
            stored.entrySet().stream().map(this::createEnchantment).forEach(this.getEntries()::add);
        }
        if (!any && this.getData().contains("tag", 10) && this.getTag().contains("Enchantments", 9)) {
            this.getTag().getList("Enchantments", 10).stream().map(CompoundTag.class::cast).map(this::createEnchantment).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.ENCHANTMENTS;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createEnchantment("", 0);
    }

    private EnchantmentEntryModel createEnchantment(Object2IntMap.Entry<Holder<Enchantment>> entry) {
        Holder holder = (Holder)entry.getKey();
        String id = holder.unwrapKey().map(key -> key.location().toString()).orElse("");
        return this.createEnchantment(id, entry.getIntValue());
    }

    private EnchantmentEntryModel createEnchantment(CompoundTag tag) {
        return this.createEnchantment(tag.getString("id"), tag.getInt("lvl"));
    }

    private EnchantmentEntryModel createEnchantment(String id, int level) {
        return new EnchantmentEntryModel((CategoryModel)this, id, level, this::addEnchantment);
    }

    public Set<ResourceLocation> getExistingEnchantmentIds() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        this.getEntries().stream().filter(EnchantmentEntryModel.class::isInstance).map(EnchantmentEntryModel.class::cast).map(ValueEntryModel::getValue).map(this::normalizeId).filter(Objects::nonNull).forEach(set::add);
        return set;
    }

    public void addEnchantmentEntryIfAbsent(String id, int level) {
        ResourceLocation rl = this.normalizeId(id);
        if (rl == null || this.getExistingEnchantmentIds().contains(rl)) {
            return;
        }
        EnchantmentEntryModel entry = this.createEnchantment(rl.toString(), level);
        int insertIndex = this.canAddEntryInList() ? Math.max(this.getEntries().size() - 1, this.getEntryListStart()) : this.getEntries().size();
        this.getEntries().add(insertIndex, entry);
        this.updateEntryListIndexes();
    }

    private ResourceLocation normalizeId(String id) {
        Object value = id.contains(":") ? id : "minecraft:" + id;
        return ResourceLocation.tryParse((String)value);
    }

    private void addEnchantment(String id, int lvl) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", id);
        tag.putInt("lvl", lvl);
        this.newEnch.add((Object)tag);
    }

    @Override
    public void apply() {
        this.newEnch = new ListTag();
        super.apply();
        ItemStack stack = this.getStack();
        Optional lookupOpt = ClientUtil.registryAccess().lookup(Registries.ENCHANTMENT);
        if (lookupOpt.isPresent()) {
            HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)lookupOpt.get();
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            for (Tag tag : this.newEnch) {
                ResourceLocation rl;
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag;
                String id = compoundTag.getString("id");
                int lvl = compoundTag.getInt("lvl");
                if (lvl <= 0 || (rl = ResourceLocation.tryParse((String)id)) == null) continue;
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)rl);
                lookup.get(key).ifPresent(holder -> mutable.set((Holder)holder, lvl));
            }
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
            this.clearLegacyEnchantments();
        } else if (!this.newEnch.isEmpty()) {
            this.getOrCreateTag().put("Enchantments", (Tag)this.newEnch);
        } else if (this.getData().contains("tag", 10) && this.getTag().contains("Enchantments")) {
            this.getTag().remove("Enchantments");
        }
    }

    private ItemStack getStack() {
        return this.getParent().getContext().getItemStack();
    }

    private void clearLegacyEnchantments() {
        CompoundTag tag;
        if (this.getData().contains("tag", 10) && (tag = this.getTag()).contains("Enchantments")) {
            tag.remove("Enchantments");
        }
    }
}

