/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FoodComponentState;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.FoodEffectEntryModel;
import com.github.rinorsi.cadeditor.client.util.CompatFood;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;

public class ItemFoodEffectsCategoryModel
extends ItemEditorCategoryModel {
    private static final int MAX_DURATION_TICKS = 72000;
    private static final int MAX_AMPLIFIER = 255;
    private final FoodComponentState state;
    private List<FoodProperties.PossibleEffect> stagedEffects = List.of();

    public ItemFoodEffectsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.gui("food_effects"), editor);
        this.state = editor.getFoodState();
    }

    @Override
    protected void setupEntries() {
        this.state.getEffects().forEach(effect -> this.getEntries().add(this.createFoodEffectEntry((FoodProperties.PossibleEffect)effect)));
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createFoodEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    @Override
    public void apply() {
        if (!this.state.isEnabled()) {
            this.stagedEffects = List.of();
            return;
        }
        this.stagedEffects = new ArrayList<FoodProperties.PossibleEffect>();
        super.apply();
        this.state.setEffects(this.stagedEffects);
        this.getParent().applyFoodComponent();
    }

    private EntryModel createFoodEffectEntry(FoodProperties.PossibleEffect effect) {
        if (effect != null) {
            MobEffectInstance instance = effect.effect();
            String id = instance.getEffect().unwrapKey().map(key -> key.location().toString()).orElse("minecraft:empty");
            return new FoodEffectEntryModel(this, id, instance.getAmplifier(), instance.getDuration(), instance.isAmbient(), instance.isVisible(), instance.showIcon(), effect.probability(), this::addFoodEffect);
        }
        String defaultId = MobEffects.MOVEMENT_SPEED.unwrapKey().map(key -> key.location().toString()).orElse("minecraft:movement_speed");
        return new FoodEffectEntryModel(this, defaultId, 0, 1, false, true, true, 1.0, this::addFoodEffect);
    }

    private void addFoodEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, float probability) {
        ArrayList list;
        Optional registryOpt = ClientUtil.registryAccess().lookup(Registries.MOB_EFFECT);
        if (registryOpt.isEmpty()) {
            return;
        }
        ResourceLocation rl = ResourceLocation.tryParse((String)id);
        if (rl == null) {
            return;
        }
        Holder holder = ((HolderLookup.RegistryLookup)registryOpt.get()).get(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)rl)).orElse(null);
        if (holder == null) {
            return;
        }
        int clampedDuration = Math.max(1, Math.min(duration, 72000));
        int clampedAmplifier = Math.max(0, Math.min(amplifier, 255));
        MobEffectInstance instance = new MobEffectInstance(holder, clampedDuration, clampedAmplifier, ambient, showParticles, showIcon);
        List<FoodProperties.PossibleEffect> list2 = this.stagedEffects;
        if (list2 instanceof ArrayList) {
            ArrayList existing;
            list = existing = (ArrayList)list2;
        } else {
            this.stagedEffects = list = new ArrayList();
        }
        CompatFood.makePossibleEffect(instance, probability).ifPresent(list::add);
    }
}

