/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.HideFlagEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;

public class ItemHideFlagsCategoryModel
extends ItemEditorCategoryModel {
    private final EnumSet<HideFlag> selectedFlags = EnumSet.noneOf(HideFlag.class);
    private final Set<DataComponentType<?>> hiddenComponents = new LinkedHashSet();
    private boolean hideEntireTooltip;

    public ItemHideFlagsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.HIDE_FLAGS, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        EnumSet<HideFlag> initial = this.readPerComponentFlags(stack);
        if (initial == null || initial.isEmpty()) {
            initial = this.readLegacyFlags(stack);
        }
        for (HideFlag flag : HideFlag.values()) {
            boolean selected = initial.contains((Object)flag);
            this.getEntries().add(new HideFlagEntryModel((CategoryModel)this, flag, selected, value -> this.setFlag(flag, (boolean)value)));
        }
    }

    private EnumSet<HideFlag> readLegacyFlags(ItemStack stack) {
        EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
        if (stack.has(DataComponents.HIDE_TOOLTIP)) {
            flags.add(HideFlag.OTHER);
        } else if (stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            for (HideFlag flag : HideFlag.values()) {
                if (flag == HideFlag.OTHER) continue;
                flags.add(flag);
            }
        } else {
            int mask = this.getTag() != null ? this.getTag().getInt("HideFlags") : 0;
            for (HideFlag flag : HideFlag.values()) {
                if ((mask & flag.getValue()) == 0) continue;
                flags.add(flag);
            }
        }
        return flags;
    }

    @Override
    public void apply() {
        this.selectedFlags.clear();
        this.hiddenComponents.clear();
        this.hideEntireTooltip = false;
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        TooltipDisplaySupport.INSTANCE.clear(stack);
        stack.remove(DataComponents.HIDE_TOOLTIP);
        stack.remove(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        this.applyPerComponentFlags(stack);
        boolean tooltipApplied = TooltipDisplaySupport.INSTANCE.apply(stack, this.hideEntireTooltip, this.hiddenComponents);
        if (!tooltipApplied) {
            this.applyLegacy(stack);
        }
        if (this.getOrCreateTag().contains("HideFlags")) {
            this.getOrCreateTag().remove("HideFlags");
        }
    }

    private EnumSet<HideFlag> readPerComponentFlags(ItemStack stack) {
        EnumSet<HideFlag> tooltipFlags = TooltipDisplaySupport.INSTANCE.read(stack);
        if (tooltipFlags != null) {
            if (stack.has(DataComponents.HIDE_TOOLTIP)) {
                tooltipFlags.add(HideFlag.OTHER);
            }
            return tooltipFlags;
        }
        EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
        try {
            block6: for (HideFlag flag : HideFlag.values()) {
                if (flag == HideFlag.OTHER) continue;
                for (DataComponentType<?> type : flag.hiddenComponents()) {
                    Object value = stack.get(type);
                    if (value == null) continue;
                    boolean show = true;
                    try {
                        Method m = value.getClass().getMethod("showInTooltip", new Class[0]);
                        show = (Boolean)m.invoke(value, new Object[0]);
                    }
                    catch (ReflectiveOperationException ignored) {
                        try {
                            Field field = value.getClass().getDeclaredField("showInTooltip");
                            field.setAccessible(true);
                            show = field.getBoolean(value);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    if (show) continue;
                    flags.add(flag);
                    continue block6;
                }
            }
            if (stack.has(DataComponents.HIDE_TOOLTIP)) {
                flags.add(HideFlag.OTHER);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flags;
    }

    private void applyLegacy(ItemStack stack) {
        if (this.hideEntireTooltip) {
            stack.set(DataComponents.HIDE_TOOLTIP, (Object)Unit.INSTANCE);
            stack.remove(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        } else {
            EnumSet<HideFlag> nonOther = EnumSet.copyOf(this.selectedFlags);
            nonOther.remove((Object)HideFlag.OTHER);
            if (!nonOther.isEmpty()) {
                stack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
                stack.remove(DataComponents.HIDE_TOOLTIP);
            } else {
                stack.remove(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
                stack.remove(DataComponents.HIDE_TOOLTIP);
            }
        }
    }

    private void setFlag(HideFlag flag, boolean value) {
        if (value) {
            this.selectedFlags.add(flag);
            if (flag == HideFlag.OTHER) {
                this.hideEntireTooltip = true;
            } else {
                this.hiddenComponents.addAll(flag.hiddenComponents());
            }
        } else {
            this.selectedFlags.remove((Object)flag);
            if (flag == HideFlag.OTHER) {
                this.hideEntireTooltip = false;
            } else {
                for (DataComponentType<?> type : flag.hiddenComponents()) {
                    boolean stillHidden = false;
                    for (HideFlag other : this.selectedFlags) {
                        if (other == HideFlag.OTHER || !other.hiddenComponents().contains(type)) continue;
                        stillHidden = true;
                        break;
                    }
                    if (stillHidden) continue;
                    this.hiddenComponents.remove(type);
                }
            }
        }
    }

    private void applyPerComponentFlags(ItemStack stack) {
        for (HideFlag flag : HideFlag.values()) {
            if (flag == HideFlag.OTHER) continue;
            boolean show = !this.selectedFlags.contains((Object)flag);
            for (DataComponentType<?> type : flag.hiddenComponents()) {
                ItemHideFlagsCategoryModel.setShowInTooltip(stack, type, show);
            }
        }
    }

    private static void setShowInTooltip(ItemStack stack, DataComponentType type, boolean show) {
        Object value = stack.get(type);
        if (value == null) {
            return;
        }
        try {
            Object newVal;
            Class<?> c = value.getClass();
            try {
                Method acc = c.getMethod("showInTooltip", new Class[0]);
                int cur = ((Boolean)acc.invoke(value, new Object[0])).booleanValue() ? 1 : 0;
                if (cur == show) {
                    return;
                }
            }
            catch (ReflectiveOperationException acc) {
                // empty catch block
            }
            for (Method m : c.getMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Boolean.TYPE || !c.isAssignableFrom(m.getReturnType())) continue;
                try {
                    newVal = m.invoke(value, show != 0);
                    if (newVal == null) continue;
                    stack.set(type, newVal);
                    return;
                }
                catch (ReflectiveOperationException newVal2) {
                    // empty catch block
                }
            }
            if (c.isRecord()) {
                RecordComponent[] comps = c.getRecordComponents();
                Object[] args = new Object[comps.length];
                Class[] types = new Class[comps.length];
                for (int i = 0; i < comps.length; ++i) {
                    RecordComponent rc = comps[i];
                    types[i] = rc.getType();
                    Method getter = rc.getAccessor();
                    Object arg = getter.invoke(value, new Object[0]);
                    if (rc.getName().equals("showInTooltip") && (types[i] == Boolean.TYPE || types[i] == Boolean.class)) {
                        arg = show != 0;
                    }
                    args[i] = arg;
                }
                Constructor<?> ctor = c.getDeclaredConstructor(types);
                ctor.setAccessible(true);
                newVal = ctor.newInstance(args);
                stack.set(type, newVal);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static enum HideFlag {
        ENCHANTMENTS(DataComponents.ENCHANTMENTS, DataComponents.STORED_ENCHANTMENTS),
        ATTRIBUTE_MODIFIERS(DataComponents.ATTRIBUTE_MODIFIERS),
        UNBREAKABLE(DataComponents.UNBREAKABLE),
        CAN_DESTROY(DataComponents.CAN_BREAK),
        CAN_PLACE_ON(DataComponents.CAN_PLACE_ON),
        OTHER(new DataComponentType[0]),
        DYED(DataComponents.DYED_COLOR),
        ARMOR_TRIMS(DataComponents.TRIM),
        JUKEBOX(DataComponents.JUKEBOX_PLAYABLE);

        private static final Map<DataComponentType<?>, HideFlag> COMPONENT_TO_FLAG;
        private final Set<DataComponentType<?>> hiddenComponents;

        private HideFlag(DataComponentType<?> ... components) {
            this.hiddenComponents = Set.of(components);
        }

        public MutableComponent getName() {
            return ModTexts.gui(this.name().toLowerCase(Locale.ROOT));
        }

        public int getValue() {
            return 1 << this.ordinal();
        }

        public Collection<DataComponentType<?>> hiddenComponents() {
            return this.hiddenComponents;
        }

        public static HideFlag fromComponent(DataComponentType<?> type) {
            return COMPONENT_TO_FLAG.get(type);
        }

        static {
            COMPONENT_TO_FLAG = new HashMap();
            for (HideFlag flag : HideFlag.values()) {
                for (DataComponentType<?> type : flag.hiddenComponents) {
                    COMPONENT_TO_FLAG.put(type, flag);
                }
            }
        }
    }

    private static final class TooltipDisplaySupport {
        static final TooltipDisplaySupport INSTANCE = new TooltipDisplaySupport();
        private final DataComponentType<Object> type;
        private final Constructor<?> ctor;
        private final Method hideTooltipGetter;
        private final Method hiddenComponentsGetter;

        private TooltipDisplaySupport() {
            DataComponentType t = null;
            Constructor<?> c = null;
            Method mHide = null;
            Method mHidden = null;
            try {
                Field field = DataComponents.class.getDeclaredField("TOOLTIP_DISPLAY");
                t = (DataComponentType)field.get(null);
                Class<?> displayClass = Class.forName("net.minecraft.world.item.component.TooltipDisplay");
                c = displayClass.getDeclaredConstructor(Boolean.TYPE, Set.class);
                mHide = displayClass.getMethod("hideTooltip", new Class[0]);
                mHidden = displayClass.getMethod("hiddenComponents", new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            this.type = t;
            this.ctor = c;
            this.hideTooltipGetter = mHide;
            this.hiddenComponentsGetter = mHidden;
        }

        private boolean available() {
            return this.type != null && this.ctor != null && this.hideTooltipGetter != null && this.hiddenComponentsGetter != null;
        }

        private EnumSet<HideFlag> read(ItemStack stack) {
            if (!this.available()) {
                return null;
            }
            Object value = stack.get(this.type);
            if (value == null) {
                return null;
            }
            EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
            try {
                Object hidden;
                if (((Boolean)this.hideTooltipGetter.invoke(value, new Object[0])).booleanValue()) {
                    flags.add(HideFlag.OTHER);
                }
                if ((hidden = this.hiddenComponentsGetter.invoke(value, new Object[0])) instanceof Iterable) {
                    Iterable it = (Iterable)hidden;
                    for (Object o : it) {
                        DataComponentType dc;
                        HideFlag flag;
                        if (!(o instanceof DataComponentType) || (flag = HideFlag.fromComponent(dc = (DataComponentType)o)) == null || flag == HideFlag.OTHER) continue;
                        flags.add(flag);
                    }
                }
            }
            catch (ReflectiveOperationException ignored) {
                return null;
            }
            return flags;
        }

        private boolean apply(ItemStack stack, boolean hideTooltip, Set<DataComponentType<?>> components) {
            if (!this.available()) {
                return false;
            }
            try {
                if (!hideTooltip && components.isEmpty()) {
                    stack.remove(this.type);
                } else {
                    Object value = this.ctor.newInstance(hideTooltip, Set.copyOf(components));
                    stack.set(this.type, value);
                }
                return true;
            }
            catch (ReflectiveOperationException ignored) {
                return false;
            }
        }

        private void clear(ItemStack stack) {
            if (this.type != null) {
                stack.remove(this.type);
            }
        }
    }
}

