/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.LodestoneTracker;

public class ItemLodestoneCategoryModel
extends ItemEditorCategoryModel {
    private boolean hasTarget;
    private String dimensionId = "minecraft:overworld";
    private int posX;
    private int posY;
    private int posZ;
    private boolean tracked;
    private StringEntryModel dimensionEntry;

    public ItemLodestoneCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.LODESTONE, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        LodestoneTracker tracker = (LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER);
        if (tracker != null) {
            this.tracked = tracker.tracked();
            Optional target = tracker.target();
            if (target.isPresent()) {
                GlobalPos pos = (GlobalPos)target.get();
                this.hasTarget = true;
                this.dimensionId = pos.dimension().location().toString();
                BlockPos bp = pos.pos();
                this.posX = bp.getX();
                this.posY = bp.getY();
                this.posZ = bp.getZ();
            } else {
                this.hasTarget = false;
            }
        } else {
            this.tracked = false;
            this.hasTarget = false;
            this.posY = 64;
        }
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LODESTONE_TARGET_TOGGLE, this.hasTarget, value -> {
            this.hasTarget = value != null && value != false;
        }));
        this.dimensionEntry = new StringEntryModel((CategoryModel)this, ModTexts.DIMENSION, this.dimensionId, value -> {
            this.dimensionId = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.dimensionEntry);
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_X, this.posX, value -> {
            this.posX = value == null ? 0 : value;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_Y, this.posY, value -> {
            this.posY = value == null ? 0 : value;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_Z, this.posZ, value -> {
            this.posZ = value == null ? 0 : value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LODESTONE_TRACKED, this.tracked, value -> {
            this.tracked = value != null && value != false;
        }));
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        boolean invalid = false;
        if (this.hasTarget) {
            ResourceLocation id = ResourceLocation.tryParse((String)this.dimensionId);
            if (id == null) {
                this.dimensionEntry.setValid(false);
                invalid = true;
            } else {
                this.dimensionEntry.setValid(true);
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
                GlobalPos pos = GlobalPos.of((ResourceKey)dimension, (BlockPos)new BlockPos(this.posX, this.posY, this.posZ));
                stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.of(pos), this.tracked));
            }
        } else {
            this.dimensionEntry.setValid(true);
            if (this.tracked) {
                stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.empty(), this.tracked));
            } else {
                stack.remove(DataComponents.LODESTONE_TRACKER);
            }
        }
        if (invalid) {
            return;
        }
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:lodestone_tracker");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }
}

