/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ArmorColorEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapId;

public class ItemMapCategoryModel
extends ItemEditorCategoryModel {
    private boolean hasMapId;
    private int mapId;
    private boolean hasMapColor;
    private int mapColor;
    private boolean hasPostProcessing;
    private MapPostProcessing postProcessing;
    private final List<StringEntryModel> decorationEntries = new ArrayList<StringEntryModel>();

    public ItemMapCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.MAP, editor);
    }

    @Override
    protected void setupEntries() {
        this.decorationEntries.clear();
        ItemStack stack = this.getParent().getContext().getItemStack();
        MapId idComponent = (MapId)stack.get(DataComponents.MAP_ID);
        this.hasMapId = idComponent != null;
        this.mapId = idComponent != null ? idComponent.id() : 0;
        MapItemColor colorComponent = (MapItemColor)stack.get(DataComponents.MAP_COLOR);
        this.hasMapColor = colorComponent != null;
        this.mapColor = colorComponent != null ? colorComponent.rgb() : MapItemColor.DEFAULT.rgb();
        this.postProcessing = (MapPostProcessing)stack.get(DataComponents.MAP_POST_PROCESSING);
        boolean bl = this.hasPostProcessing = this.postProcessing != null;
        if (this.postProcessing == null) {
            this.postProcessing = MapPostProcessing.LOCK;
        }
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.MAP_ID_TOGGLE, this.hasMapId, value -> {
            this.hasMapId = value != null && value != false;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.MAP_ID_VALUE, this.mapId, value -> {
            this.mapId = value == null ? 0 : value;
        }));
        this.getEntries().add(new ArmorColorEntryModel(this, this.hasMapColor ? this.mapColor : Integer.MIN_VALUE, value -> {
            if (value == Integer.MIN_VALUE) {
                this.hasMapColor = false;
                this.mapColor = MapItemColor.DEFAULT.rgb();
            } else {
                this.hasMapColor = true;
                this.mapColor = value;
            }
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.MAP_POST_PROCESSING_TOGGLE, this.hasPostProcessing, value -> {
            this.hasPostProcessing = value != null && value != false;
        }));
        this.getEntries().add(new EnumEntryModel<MapPostProcessing>((CategoryModel)this, ModTexts.MAP_POST_PROCESSING, MapPostProcessing.values(), this.postProcessing, value -> {
            this.postProcessing = value == null ? MapPostProcessing.LOCK : value;
        }));
        MapDecorations decorations = (MapDecorations)stack.get(DataComponents.MAP_DECORATIONS);
        if (decorations != null) {
            decorations.decorations().forEach((name, entry) -> this.getEntries().add(this.createDecorationEntry(this.formatDecoration((String)name, (MapDecorations.Entry)entry))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 5;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createDecorationEntry("");
    }

    private EntryModel createDecorationEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.MAP_DECORATION, spec, value -> {});
        this.decorationEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (this.hasMapId) {
            stack.set(DataComponents.MAP_ID, (Object)new MapId(this.mapId));
        } else {
            stack.remove(DataComponents.MAP_ID);
        }
        if (this.hasMapColor) {
            stack.set(DataComponents.MAP_COLOR, (Object)new MapItemColor(this.mapColor));
        } else {
            stack.remove(DataComponents.MAP_COLOR);
        }
        if (this.hasPostProcessing && this.postProcessing != null) {
            stack.set(DataComponents.MAP_POST_PROCESSING, (Object)this.postProcessing);
        } else {
            stack.remove(DataComponents.MAP_POST_PROCESSING);
        }
        HolderLookup.RegistryLookup decorationLookup = ClientUtil.registryAccess().lookup(Registries.MAP_DECORATION_TYPE).orElse(null);
        LinkedHashMap<String, MapDecorations.Entry> parsedDecorations = new LinkedHashMap<String, MapDecorations.Entry>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.decorationEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<Map.Entry<String, MapDecorations.Entry>> parsed = this.parseDecoration(spec, (HolderLookup.RegistryLookup<MapDecorationType>)decorationLookup);
            if (parsed.isPresent()) {
                parsedDecorations.put(parsed.get().getKey(), parsed.get().getValue());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedDecorations.isEmpty()) {
            stack.remove(DataComponents.MAP_DECORATIONS);
        } else {
            stack.set(DataComponents.MAP_DECORATIONS, (Object)new MapDecorations(parsedDecorations));
        }
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:map_id");
            components.remove("minecraft:map_post_processing");
            components.remove("minecraft:map_color");
            components.remove("minecraft:map_decorations");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }

    private String formatDecoration(String name, MapDecorations.Entry entry) {
        String typeId = entry.type().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("");
        return name + "|" + typeId + "|" + entry.x() + "|" + entry.z() + "|" + entry.rotation();
    }

    private Optional<Map.Entry<String, MapDecorations.Entry>> parseDecoration(String spec, HolderLookup.RegistryLookup<MapDecorationType> lookup) {
        String[] parts = spec.split("\\|", -1);
        if (parts.length < 5) {
            return Optional.empty();
        }
        String name = parts[0].trim();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        ResourceLocation typeId = ResourceLocation.tryParse((String)parts[1].trim());
        if (typeId == null || lookup == null) {
            return Optional.empty();
        }
        Optional holder = lookup.get(ResourceKey.create((ResourceKey)Registries.MAP_DECORATION_TYPE, (ResourceLocation)typeId));
        if (holder.isEmpty()) {
            return Optional.empty();
        }
        try {
            double x = Double.parseDouble(parts[2].trim());
            double z = Double.parseDouble(parts[3].trim());
            float rotation = Float.parseFloat(parts[4].trim());
            MapDecorations.Entry entry = new MapDecorations.Entry((Holder)holder.get(), x, z, rotation);
            return Optional.of(new AbstractMap.SimpleEntry<String, MapDecorations.Entry>(name, entry));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

