/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntityEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;

public class ItemSpawnEggCategoryModel
extends ItemEditorCategoryModel {
    private final SpawnEggItem item;
    private CompoundTag spawnData;

    public ItemSpawnEggCategoryModel(ItemEditorModel editor, SpawnEggItem item) {
        super((Component)ModTexts.SPAWN_EGG, editor);
        this.item = item;
        this.spawnData = ItemSpawnEggCategoryModel.readSpawnData(editor.getContext().getItemStack(), editor.getContext().getTag());
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        EntityEntryModel entityEntry = new EntityEntryModel((CategoryModel)this, EntityType.by((CompoundTag)this.spawnData).orElse(this.item.getType(stack)), this.spawnData, this::setEntity);
        this.getEntries().add((EntryModel)entityEntry.withWeight(0));
        this.spawnData = entityEntry.copyValue();
    }

    private void setEntity(CompoundTag compoundTag) {
        this.spawnData = compoundTag == null ? new CompoundTag() : compoundTag.copy();
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (stack == null) {
            return;
        }
        CompoundTag itemData = this.getData();
        if (this.spawnData == null || this.spawnData.isEmpty() || !this.spawnData.contains("id", 8) || this.spawnData.getString("id").isEmpty()) {
            if (itemData.contains("tag", 10)) {
                CompoundTag tag = itemData.getCompound("tag");
                tag.remove("EntityTag");
                if (tag.isEmpty()) {
                    itemData.remove("tag");
                }
            }
            stack.remove(DataComponents.ENTITY_DATA);
            this.spawnData = new CompoundTag();
            return;
        }
        CompoundTag sanitized = this.spawnData.copy();
        this.getOrCreateTag().put("EntityTag", (Tag)sanitized.copy());
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)sanitized));
        this.spawnData = sanitized;
    }

    private static CompoundTag readSpawnData(ItemStack stack, CompoundTag rootTag) {
        CompoundTag legacy;
        CustomData data;
        if (stack != null && (data = (CustomData)stack.get(DataComponents.ENTITY_DATA)) != null && !data.isEmpty()) {
            return data.copyTag();
        }
        if (rootTag != null && rootTag.contains("tag", 10) && (legacy = rootTag.getCompound("tag")).contains("EntityTag", 10)) {
            return legacy.getCompound("EntityTag").copy();
        }
        return new CompoundTag();
    }
}

