/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ToolRuleEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;

public class ItemToolCategoryModel
extends ItemEditorCategoryModel {
    private float defaultMiningSpeed;
    private int damagePerBlock;

    public ItemToolCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.TOOL, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool != null) {
            this.defaultMiningSpeed = tool.defaultMiningSpeed();
            this.damagePerBlock = tool.damagePerBlock();
        } else {
            Item item = stack.getItem();
            if (item instanceof DiggerItem) {
                DiggerItem digger = (DiggerItem)item;
                this.defaultMiningSpeed = digger.getTier().getSpeed();
                this.damagePerBlock = digger.getTier().getUses() > 0 ? 1 : 0;
            } else {
                this.defaultMiningSpeed = 1.0f;
                this.damagePerBlock = 0;
            }
        }
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, ModTexts.TOOL_MINING_SPEED, this.defaultMiningSpeed, value -> {
            this.defaultMiningSpeed = value == null ? 1.0f : value.floatValue();
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.TOOL_DAMAGE_PER_BLOCK, this.damagePerBlock, value -> {
            this.damagePerBlock = value == null ? 0 : Math.max(0, value);
        }));
        if (tool != null) {
            tool.rules().forEach(rule -> this.getEntries().add(new ToolRuleEntryModel(this, (Tool.Rule)rule)));
        }
    }

    @Override
    public int getEntryListStart() {
        return 2;
    }

    @Override
    public EntryModel createNewListEntry() {
        return new ToolRuleEntryModel(this);
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        HolderLookup.RegistryLookup blockLookup = ClientUtil.registryAccess().lookup(Registries.BLOCK).orElse(null);
        ArrayList<Tool.Rule> parsedRules = new ArrayList<Tool.Rule>();
        boolean hasInvalid = false;
        for (EntryModel entry : this.getEntries()) {
            if (!(entry instanceof ToolRuleEntryModel)) continue;
            ToolRuleEntryModel rule = (ToolRuleEntryModel)entry;
            if (!rule.hasSelection() && rule.getSpeedText().isBlank()) {
                rule.setValid(true);
                continue;
            }
            if (blockLookup == null) {
                rule.setValid(false);
                hasInvalid = true;
                continue;
            }
            Optional<Tool.Rule> parsed = rule.toRule((HolderLookup.RegistryLookup<Block>)blockLookup);
            if (parsed.isPresent()) {
                parsedRules.add(parsed.get());
                rule.setValid(true);
                continue;
            }
            rule.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedRules.isEmpty() && (double)Math.abs(this.defaultMiningSpeed - 1.0f) < 1.0E-6 && this.damagePerBlock <= 0) {
            stack.remove(DataComponents.TOOL);
        } else {
            stack.set(DataComponents.TOOL, (Object)new Tool(parsedRules, this.defaultMiningSpeed, this.damagePerBlock));
        }
        CompoundTag tag = this.getData();
        if (tag != null && tag.contains("components")) {
            CompoundTag components = tag.getCompound("components");
            components.remove("minecraft:tool");
            if (components.isEmpty()) {
                tag.remove("components");
            }
        }
    }
}

