/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;

public class ItemTrimCategoryModel
extends ItemEditorCategoryModel {
    private String patternId = "";
    private String materialId = "";
    private boolean showInTooltip = true;
    private StringEntryModel patternEntry;
    private StringEntryModel materialEntry;

    public ItemTrimCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.TRIM, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim != null) {
            this.patternId = trim.pattern().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("");
            this.materialId = trim.material().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("");
            this.showInTooltip = !trim.withTooltip(false).equals((Object)trim);
        } else {
            this.showInTooltip = true;
        }
        this.patternEntry = new StringEntryModel((CategoryModel)this, ModTexts.TRIM_PATTERN, this.patternId, value -> {
            this.patternId = value == null ? "" : value.trim();
        });
        this.materialEntry = new StringEntryModel((CategoryModel)this, ModTexts.TRIM_MATERIAL, this.materialId, value -> {
            this.materialId = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.patternEntry);
        this.getEntries().add(this.materialEntry);
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.TRIM_SHOW_TOOLTIP, this.showInTooltip, value -> {
            this.showInTooltip = value == null || value != false;
        }));
    }

    @Override
    public void apply() {
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        HolderLookup.RegistryLookup patternLookup = ClientUtil.registryAccess().lookup(Registries.TRIM_PATTERN).orElse(null);
        HolderLookup.RegistryLookup materialLookup = ClientUtil.registryAccess().lookup(Registries.TRIM_MATERIAL).orElse(null);
        Optional<Holder.Reference<TrimPattern>> patternHolder = this.resolvePattern((HolderLookup.RegistryLookup<TrimPattern>)patternLookup, this.patternId);
        Optional<Holder.Reference<TrimMaterial>> materialHolder = this.resolveMaterial((HolderLookup.RegistryLookup<TrimMaterial>)materialLookup, this.materialId);
        if (patternHolder.isEmpty() || materialHolder.isEmpty()) {
            this.patternEntry.setValid(patternHolder.isPresent());
            this.materialEntry.setValid(materialHolder.isPresent());
            return;
        }
        this.patternEntry.setValid(true);
        this.materialEntry.setValid(true);
        ArmorTrim trim = new ArmorTrim((Holder)materialHolder.get(), (Holder)patternHolder.get(), this.showInTooltip);
        stack.set(DataComponents.TRIM, (Object)trim);
        CompoundTag data = this.getData();
        if (data != null && data.contains("components")) {
            CompoundTag components = data.getCompound("components");
            components.remove("minecraft:trim");
            if (components.isEmpty()) {
                data.remove("components");
            }
        }
    }

    private Optional<Holder.Reference<TrimPattern>> resolvePattern(HolderLookup.RegistryLookup<TrimPattern> lookup, String id) {
        ResourceLocation rl;
        if (lookup == null) {
            return Optional.empty();
        }
        ResourceLocation resourceLocation = rl = id.isBlank() ? null : ResourceLocation.tryParse((String)id);
        if (rl == null) {
            return Optional.empty();
        }
        return lookup.get(ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)rl));
    }

    private Optional<Holder.Reference<TrimMaterial>> resolveMaterial(HolderLookup.RegistryLookup<TrimMaterial> lookup, String id) {
        ResourceLocation rl;
        if (lookup == null) {
            return Optional.empty();
        }
        ResourceLocation resourceLocation = rl = id.isBlank() ? null : ResourceLocation.tryParse((String)id);
        if (rl == null) {
            return Optional.empty();
        }
        return lookup.get(ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)rl));
    }
}

