/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ValueEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityEntryModel
extends ValueEntryModel<CompoundTag> {
    private final ObjectProperty<EntityType<?>> entityTypeProperty;
    private final ObjectProperty<String> entityIdProperty;

    public EntityEntryModel(CategoryModel category, EntityType<?> entityType, CompoundTag spawnData, Consumer<CompoundTag> action) {
        super(category, ModTexts.ENTITY, EntityEntryModel.sanitizeInitialValue(spawnData, entityType), action);
        this.entityTypeProperty = ObjectProperty.create(entityType);
        this.entityIdProperty = ObjectProperty.create("");
        this.syncFromValue((CompoundTag)this.getValue());
    }

    @Override
    public void apply() {
        this.setValue((CompoundTag)this.getValue());
        super.apply();
        this.defaultValue = this.copyValue();
    }

    @Override
    public void reset() {
        this.setValue(this.defaultValue == null ? new CompoundTag() : ((CompoundTag)this.defaultValue).copy());
    }

    @Override
    public void setValue(CompoundTag value) {
        CompoundTag sanitized = this.sanitizeIncomingValue(value);
        super.setValue(sanitized);
        this.syncFromValue(sanitized);
    }

    public void setEntityId(String rawValue) {
        this.setValue(this.updateIdCopy((CompoundTag)this.getValue(), rawValue));
    }

    public String getEntityId() {
        return (String)this.entityIdProperty().getValue();
    }

    public ObjectProperty<String> entityIdProperty() {
        return this.entityIdProperty;
    }

    public EntityType<?> getEntityType() {
        return (EntityType)this.entityTypeProperty().getValue();
    }

    public ObjectProperty<EntityType<?>> entityTypeProperty() {
        return this.entityTypeProperty;
    }

    public CompoundTag copyValue() {
        CompoundTag value = (CompoundTag)this.getValue();
        return value == null ? new CompoundTag() : value.copy();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ENTITY;
    }

    private void syncFromValue(CompoundTag value) {
        String id = value.contains("id", 8) ? value.getString("id") : "";
        EntityType<?> type = EntityEntryModel.findEntityType(id);
        if (type != null) {
            String canonical = Objects.requireNonNull(EntityType.getKey(type)).toString();
            if (!Objects.equals(canonical, id)) {
                value.putString("id", canonical);
                id = canonical;
            }
            this.entityTypeProperty().setValue(type);
            this.entityIdProperty().setValue(canonical);
            this.setValid(true);
        } else {
            this.entityTypeProperty().setValue(null);
            this.entityIdProperty().setValue(id);
            this.setValid(false);
        }
    }

    private static CompoundTag sanitizeInitialValue(CompoundTag spawnData, EntityType<?> entityType) {
        CompoundTag value;
        CompoundTag compoundTag = value = spawnData == null ? new CompoundTag() : spawnData.copy();
        if ((value == null || !value.contains("id", 8) || value.getString("id").isEmpty()) && entityType != null) {
            value.putString("id", Objects.requireNonNull(EntityType.getKey(entityType)).toString());
        }
        return value;
    }

    private CompoundTag sanitizeIncomingValue(CompoundTag incoming) {
        CompoundTag value = incoming == null ? new CompoundTag() : incoming.copy();
        String id = value.contains("id", 8) ? value.getString("id") : "";
        EntityType<?> type = EntityEntryModel.findEntityType(id);
        if (type != null) {
            String canonical = Objects.requireNonNull(EntityType.getKey(type)).toString();
            if (!Objects.equals(canonical, id)) {
                value.putString("id", canonical);
            }
        } else if ((id == null || id.isEmpty()) && this.getEntityType() != null) {
            value.putString("id", Objects.requireNonNull(EntityType.getKey(this.getEntityType())).toString());
        }
        return value;
    }

    private CompoundTag updateIdCopy(CompoundTag source, String raw) {
        String trimmed;
        CompoundTag value = source == null ? new CompoundTag() : source.copy();
        String string = trimmed = raw == null ? "" : raw.trim();
        if (trimmed.isEmpty()) {
            value.remove("id");
            return value;
        }
        ResourceLocation location = ClientUtil.parseResourceLocation(trimmed);
        value.putString("id", location != null ? location.toString() : trimmed);
        return value;
    }

    private static EntityType<?> findEntityType(String value) {
        ResourceLocation location = ClientUtil.parseResourceLocation(value);
        return location == null ? null : (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(location).orElse(null);
    }
}

