/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.entity;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityEquipmentCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EntityEquipmentEntryModel
extends EntryModel {
    private final EntityEquipmentCategoryModel category;
    private final EntityEquipmentCategoryModel.Slot slot;
    private final ObjectProperty<ItemStack> itemProperty;
    private final ObjectProperty<Float> dropChanceProperty;
    private ItemStack defaultItem;
    private float defaultDropChance;

    public EntityEquipmentEntryModel(EntityEquipmentCategoryModel category, EntityEquipmentCategoryModel.Slot slot, ItemStack stack, float dropChance) {
        super(category);
        this.category = category;
        this.slot = slot;
        this.defaultItem = this.sanitize(stack);
        this.defaultDropChance = dropChance;
        this.itemProperty = ObjectProperty.create(this.defaultItem.copy());
        this.dropChanceProperty = ObjectProperty.create(Float.valueOf(dropChance));
        this.itemProperty.addListener(value -> this.invalidateIfNecessary());
        this.dropChanceProperty.addListener(value -> this.invalidateIfNecessary());
        this.invalidateIfNecessary();
    }

    public EntityEquipmentCategoryModel.Slot getSlot() {
        return this.slot;
    }

    public MutableComponent getSlotLabel() {
        return this.slot.label();
    }

    public ItemStack getItemStack() {
        ItemStack current = (ItemStack)this.itemProperty.getValue();
        return current == null ? ItemStack.EMPTY : current;
    }

    public ObjectProperty<ItemStack> itemStackProperty() {
        return this.itemProperty;
    }

    public void setItemStack(ItemStack stack) {
        ItemStack sanitized = this.sanitize(stack);
        this.itemProperty.setValue(sanitized);
        this.invalidateIfNecessary();
    }

    private ItemStack sanitize(ItemStack stack) {
        if (stack == null) {
            return ItemStack.EMPTY;
        }
        if (stack.getItem() == Items.STICK) {
            return new ItemStack((ItemLike)Items.STICK);
        }
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        if (copy.getCount() <= 0) {
            copy.setCount(1);
        }
        return copy;
    }

    public float getDropChance() {
        Float value = (Float)this.dropChanceProperty.getValue();
        return value == null ? this.slot.defaultDropChance() : value.floatValue();
    }

    public ObjectProperty<Float> dropChanceProperty() {
        return this.dropChanceProperty;
    }

    public void setDropChance(float chance) {
        float clamped = Math.max(0.0f, Math.min(1.0f, chance));
        this.dropChanceProperty.setValue(Float.valueOf(clamped));
        this.invalidateIfNecessary();
    }

    public String formatDropChance() {
        return this.category.formatDropChance(this.getDropChance());
    }

    public boolean isDropChanceTextValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void setDropChanceFromText(String text) {
        if (!this.isDropChanceTextValid(text)) {
            this.setValid(false);
            return;
        }
        try {
            this.setDropChance(Float.parseFloat(text));
        }
        catch (NumberFormatException ex) {
            this.setValid(false);
        }
    }

    public CompoundTag createItemTag() {
        ItemStack stack = this.getItemStack();
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        return (CompoundTag)stack.save(ClientUtil.registryAccess(), (Tag)new CompoundTag());
    }

    public void markAsDefault() {
        this.defaultItem = this.getItemStack().copy();
        this.defaultDropChance = this.getDropChance();
    }

    public float getDefaultDropChance() {
        return this.defaultDropChance;
    }

    @Override
    public void reset() {
        this.setItemStack(this.defaultItem.copy());
        this.setDropChance(this.defaultDropChance);
    }

    @Override
    public void apply() {
        this.markAsDefault();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ENTITY_EQUIPMENT;
    }

    private void invalidateIfNecessary() {
        Float value = (Float)this.dropChanceProperty.getValue();
        boolean valid = value != null && Float.isFinite(value.floatValue()) && value.floatValue() >= 0.0f && value.floatValue() <= 1.0f;
        this.setValid(valid);
    }

    public boolean isDefaultDropChance() {
        return Math.abs(this.getDropChance() - this.slot.defaultDropChance()) < 1.0E-4f;
    }

    @Override
    public boolean isResetable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityEquipmentEntryModel)) {
            return false;
        }
        EntityEquipmentEntryModel that = (EntityEquipmentEntryModel)o;
        return this.slot == that.slot;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slot});
    }
}

