/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemContainerSlotEntryModel
extends EntryModel {
    private final ItemEditorCategoryModel category;
    private ItemStack defaultStack;
    private final ObjectProperty<ItemStack> stackProperty;

    public ItemContainerSlotEntryModel(ItemEditorCategoryModel category, ItemStack stack) {
        super(category);
        this.category = category;
        this.defaultStack = this.sanitize(stack);
        this.stackProperty = ObjectProperty.create(this.defaultStack.copy());
        this.stackProperty.addListener(value -> this.setValid(true));
    }

    private ItemStack sanitize(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        if (copy.getCount() <= 0) {
            copy.setCount(1);
        }
        return copy;
    }

    public ItemEditorCategoryModel getContainerCategory() {
        return this.category;
    }

    public Component getSlotLabel() {
        int index = Math.max(0, this.getListIndex());
        return Component.literal((String)String.format("#%02d", index + 1));
    }

    public ObjectProperty<ItemStack> itemStackProperty() {
        return this.stackProperty;
    }

    public ItemStack getItemStack() {
        ItemStack current = (ItemStack)this.stackProperty.getValue();
        return current == null ? ItemStack.EMPTY : current;
    }

    public void setItemStack(ItemStack stack) {
        ItemStack sanitized = this.sanitize(stack);
        if (!Objects.equals(this.stackProperty.getValue(), sanitized)) {
            this.stackProperty.setValue(sanitized);
        }
    }

    @Override
    public void reset() {
        this.setItemStack(this.defaultStack.copy());
    }

    @Override
    public void apply() {
        this.defaultStack = this.getItemStack().copy();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.CONTAINER_SLOT;
    }
}

