/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;

public class ToolRuleEntryModel
extends EntryModel {
    private final List<ResourceLocation> blockIds = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> tagIds = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> defaultBlockIds = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> defaultTagIds = new ArrayList<ResourceLocation>();
    private final ObjectProperty<DropBehavior> behaviorProperty = ObjectProperty.create(DropBehavior.INHERIT);
    private DropBehavior defaultBehavior = DropBehavior.INHERIT;
    private String speedText = "";
    private Float speedValue;
    private String defaultSpeedText = "";
    private Float defaultSpeedValue;

    public ToolRuleEntryModel(ItemEditorCategoryModel category) {
        this(category, null);
    }

    public ToolRuleEntryModel(ItemEditorCategoryModel category, Tool.Rule rule) {
        super(category);
        if (rule != null) {
            rule.blocks().unwrapKey().ifPresent(tagKey -> this.tagIds.add(tagKey.location()));
            if (this.tagIds.isEmpty()) {
                rule.blocks().stream().map(holder -> holder.unwrapKey().map(ResourceKey::location).orElse(null)).filter(id -> id != null).forEach(this.blockIds::add);
            }
            rule.speed().ifPresent(value -> {
                this.speedValue = value;
                this.speedText = this.trimFloat(value.floatValue());
            });
            this.behaviorProperty.setValue(DropBehavior.fromOptional(rule.correctForDrops()));
        }
        this.captureDefaults();
    }

    public List<ResourceLocation> getBlockIds() {
        return List.copyOf(this.blockIds);
    }

    public void setBlockIds(List<ResourceLocation> ids) {
        this.blockIds.clear();
        ids.stream().distinct().forEach(this.blockIds::add);
    }

    public List<ResourceLocation> getTagIds() {
        return List.copyOf(this.tagIds);
    }

    public void setTagIds(List<ResourceLocation> ids) {
        this.tagIds.clear();
        ids.stream().distinct().forEach(this.tagIds::add);
    }

    public void clearSelections() {
        this.blockIds.clear();
        this.tagIds.clear();
    }

    public DropBehavior getBehavior() {
        return (DropBehavior)((Object)this.behaviorProperty.getValue());
    }

    public ObjectProperty<DropBehavior> behaviorProperty() {
        return this.behaviorProperty;
    }

    public void setBehavior(DropBehavior behavior) {
        this.behaviorProperty.setValue(behavior == null ? DropBehavior.INHERIT : behavior);
    }

    public String getSpeedText() {
        return this.speedText;
    }

    public boolean setSpeedText(String text) {
        String trimmed;
        this.speedText = trimmed = text == null ? "" : text.trim();
        if (trimmed.isEmpty()) {
            this.speedValue = null;
            return true;
        }
        try {
            this.speedValue = Float.valueOf(Float.parseFloat(trimmed));
            return true;
        }
        catch (NumberFormatException ex) {
            this.speedValue = null;
            return false;
        }
    }

    public boolean hasSelection() {
        return !this.blockIds.isEmpty() || !this.tagIds.isEmpty();
    }

    public Component getSummaryComponent() {
        if (!this.hasSelection()) {
            return ModTexts.gui("tool_rule_blocks_empty").copy().withStyle(ChatFormatting.GRAY);
        }
        List<Component> entries = this.buildSummaryEntries();
        if (entries.isEmpty()) {
            return ModTexts.gui("tool_rule_blocks_empty").copy().withStyle(ChatFormatting.GRAY);
        }
        MutableComponent first = entries.get(0).copy();
        String text = first.getString();
        int maxLength = 255;
        if (text.length() > maxLength) {
            first = Component.literal((String)(text.substring(0, maxLength - 1) + "...")).withStyle(first.getStyle());
        }
        if (entries.size() > 1) {
            first.append((Component)Component.literal((String)(" +" + (entries.size() - 1))).withStyle(ChatFormatting.DARK_GRAY));
        }
        return first;
    }

    public List<Component> getSummaryTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!this.hasSelection()) {
            tooltip.add((Component)ModTexts.gui("tool_rule_blocks_empty").copy().withStyle(ChatFormatting.GRAY));
        } else {
            this.addSectionLines(tooltip, ModTexts.gui("tool_rule_tags").copy(), this.tagIds, true);
            this.addSectionLines(tooltip, ModTexts.gui("tool_rule_blocks").copy(), this.blockIds, false);
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)this.buildSpeedTooltip());
        tooltip.add((Component)this.buildBehaviorTooltip());
        return tooltip;
    }

    private List<Component> buildSummaryEntries() {
        ArrayList<Component> entries = new ArrayList<Component>();
        this.tagIds.forEach(id -> entries.add((Component)Component.literal((String)("#" + String.valueOf(id))).withStyle(ChatFormatting.AQUA)));
        this.blockIds.forEach(id -> entries.add((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.WHITE)));
        return entries;
    }

    private void addSectionLines(List<Component> tooltip, MutableComponent title, List<ResourceLocation> ids, boolean tags) {
        if (ids.isEmpty()) {
            return;
        }
        tooltip.add((Component)title.withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)Integer.toString(ids.size())).withStyle(ChatFormatting.GOLD)));
        ids.forEach(id -> {
            Object text = tags ? "#" + String.valueOf(id) : id.toString();
            tooltip.add((Component)Component.literal((String)("  " + (String)text)).withStyle(tags ? ChatFormatting.AQUA : ChatFormatting.WHITE));
        });
    }

    private MutableComponent buildSpeedTooltip() {
        MutableComponent line = ModTexts.gui("tool_rule_speed").copy().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY));
        if (this.speedValue != null) {
            line.append((Component)Component.literal((String)this.trimFloat(this.speedValue.floatValue())).withStyle(ChatFormatting.GOLD));
        } else if (!this.speedText.isEmpty()) {
            line.append((Component)Component.literal((String)this.speedText).withStyle(ChatFormatting.RED));
        } else {
            line.append((Component)Component.literal((String)"-").withStyle(ChatFormatting.DARK_GRAY));
        }
        return line;
    }

    private MutableComponent buildBehaviorTooltip() {
        return ModTexts.gui("tool_rule_behavior").copy().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)((DropBehavior)((Object)this.behaviorProperty.getValue())).getText().copy()).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)((DropBehavior)((Object)this.behaviorProperty.getValue())).getDescription().copy());
    }

    public Optional<Tool.Rule> toRule(HolderLookup.RegistryLookup<Block> lookup) {
        if (!this.hasSelection() || lookup == null) {
            return Optional.empty();
        }
        if (this.tagIds.size() == 1 && this.blockIds.isEmpty()) {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.tagIds.get(0));
            Optional named = lookup.get(tagKey);
            if (named.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Tool.Rule((HolderSet)named.get(), Optional.ofNullable(this.speedValue), ((DropBehavior)((Object)this.behaviorProperty.getValue())).toOptional()));
        }
        LinkedHashSet<Holder> holders = new LinkedHashSet<Holder>();
        for (ResourceLocation tagId : this.tagIds) {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId);
            Optional named = lookup.get(tagKey);
            if (named.isEmpty()) {
                return Optional.empty();
            }
            ((HolderSet.Named)named.get()).stream().forEach(holders::add);
        }
        for (ResourceLocation blockId : this.blockIds) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)blockId);
            Optional holder = lookup.get(key);
            if (holder.isEmpty()) {
                return Optional.empty();
            }
            holders.add((Holder)holder.get());
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        HolderSet.Direct blockSet = HolderSet.direct(new ArrayList(holders));
        return Optional.of(new Tool.Rule((HolderSet)blockSet, Optional.ofNullable(this.speedValue), ((DropBehavior)((Object)this.behaviorProperty.getValue())).toOptional()));
    }

    public void setFromRule(Tool.Rule rule) {
        this.tagIds.clear();
        this.blockIds.clear();
        if (rule.blocks().unwrapKey().isPresent()) {
            this.tagIds.add(((TagKey)rule.blocks().unwrapKey().get()).location());
        } else {
            rule.blocks().stream().map(holder -> holder.unwrapKey().map(ResourceKey::location).orElse(null)).filter(id -> id != null).forEach(this.blockIds::add);
        }
        rule.speed().ifPresentOrElse(value -> {
            this.speedValue = value;
            this.speedText = this.trimFloat(value.floatValue());
        }, () -> {
            this.speedValue = null;
            this.speedText = "";
        });
        this.behaviorProperty.setValue(DropBehavior.fromOptional(rule.correctForDrops()));
        this.captureDefaults();
    }

    @Override
    public void reset() {
        this.blockIds.clear();
        this.blockIds.addAll(this.defaultBlockIds);
        this.tagIds.clear();
        this.tagIds.addAll(this.defaultTagIds);
        this.behaviorProperty.setValue(this.defaultBehavior);
        this.speedValue = this.defaultSpeedValue;
        this.speedText = this.defaultSpeedText;
        this.setValid(true);
    }

    @Override
    public void apply() {
        this.captureDefaults();
        this.setValid(true);
    }

    private void captureDefaults() {
        this.defaultBlockIds.clear();
        this.defaultBlockIds.addAll(this.blockIds);
        this.defaultTagIds.clear();
        this.defaultTagIds.addAll(this.tagIds);
        this.defaultBehavior = (DropBehavior)((Object)this.behaviorProperty.getValue());
        this.defaultSpeedValue = this.speedValue;
        this.defaultSpeedText = this.speedText;
    }

    private String trimFloat(float value) {
        String text = Float.toString(value);
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.TOOL_RULE;
    }

    public static enum DropBehavior {
        INHERIT("inherit"),
        ALLOW("allow"),
        DENY("deny");

        private final String translationSuffix;

        private DropBehavior(String translationSuffix) {
            this.translationSuffix = translationSuffix;
        }

        public Component getText() {
            return Component.translatable((String)("cadeditor.gui.tool_rule_behavior." + this.translationSuffix));
        }

        public MutableComponent getDescription() {
            return Component.translatable((String)("cadeditor.gui.tool_rule_behavior.desc." + this.translationSuffix)).withStyle(ChatFormatting.DARK_GRAY);
        }

        public Optional<Boolean> toOptional() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Optional.empty();
                case 1 -> Optional.of(true);
                case 2 -> Optional.of(false);
            };
        }

        public static DropBehavior fromOptional(Optional<Boolean> optional) {
            if (optional.isEmpty()) {
                return INHERIT;
            }
            return optional.get() != false ? ALLOW : DENY;
        }
    }
}

