/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.View;
import com.github.franckyi.guapi.api.node.Button;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.TexturedToggleButton;
import com.github.franckyi.guapi.api.node.VBox;
import com.github.franckyi.guapi.api.node.builder.ButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedToggleButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.VBoxBuilder;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.ModTextures;
import com.github.rinorsi.cadeditor.client.UpdateLogRegistry;
import com.github.rinorsi.cadeditor.client.util.ScreenScalingManager;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ScreenView
implements View {
    private VBox root;
    private Label headerLabel;
    private TexturedToggleButton copyCommandButton;
    private TexturedToggleButton saveVaultButton;
    private TexturedButton loadVaultButton;
    private TexturedButton openEditorButton;
    private TexturedButton openNBTEditorButton;
    private TexturedButton openSNBTEditorButton;
    private TexturedButton zoomResetButton;
    private TexturedButton zoomOutButton;
    private TexturedButton zoomInButton;
    private Button cancelButton;
    private Button saveButton;
    private Button doneButton;
    private Label zoomLabel;
    protected HBox buttonBar;
    protected HBox buttonBarLeft;
    protected HBox editorButtons;
    protected HBox buttonBarCenter;
    protected HBox buttonBarRight;

    @Override
    public void build() {
        this.root = GuapiHelper.vBox(root -> {
            ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)root.spacing(5)).align(GuapiHelper.CENTER)).padding(5)).fillWidth();
            root.add(this.createHeader());
            root.add(this.createMain(), 1);
            root.add(this.createFooter());
        });
        ScreenScalingManager.get().scaleProperty().addListener(this::onZoomUpdated);
        this.zoomResetButton.disableProperty().bind(ScreenScalingManager.get().canScaleBeResetProperty().not());
        this.onZoomUpdated();
    }

    protected Node createHeader() {
        return GuapiHelper.hBox(header -> {
            header.add((Node)GuapiHelper.hBox().prefWidth(16));
            this.headerLabel = (Label)((LabelBuilder)GuapiHelper.label((Component)this.getHeaderLabelText()).textAlign(GuapiHelper.CENTER)).prefHeight(20);
            header.add(this.headerLabel, 1);
            header.add((Node)this.createButton(ModTextures.SETTINGS, ModTexts.SETTINGS).action(ModScreenHandler::openSettingsScreen));
            header.align(GuapiHelper.CENTER);
        });
    }

    protected MutableComponent getHeaderLabelText() {
        return GuapiHelper.EMPTY_TEXT;
    }

    protected Node createMain() {
        return GuapiHelper.vBox(main -> {
            main.add(this.createButtonBar());
            main.add(this.createEditor(), 1);
            ((VBoxBuilder)main.spacing(2)).fillWidth();
        });
    }

    protected Node createButtonBar() {
        this.buttonBar = GuapiHelper.hBox(buttons -> {
            Node[] nodeArray = new Node[1];
            this.editorButtons = (HBox)GuapiHelper.hBox().spacing(2);
            nodeArray[0] = this.editorButtons;
            this.buttonBarLeft = (HBox)((HBoxBuilder)GuapiHelper.hBox(nodeArray).align(GuapiHelper.CENTER_LEFT)).spacing(10);
            buttons.add(this.buttonBarLeft);
            this.buttonBarCenter = (HBox)((HBoxBuilder)GuapiHelper.hBox().align(GuapiHelper.CENTER)).spacing(10);
            buttons.add(this.buttonBarCenter, 1);
            this.buttonBarRight = (HBox)((HBoxBuilder)GuapiHelper.hBox().align(GuapiHelper.CENTER_RIGHT)).spacing(10);
            buttons.add(this.buttonBarRight);
            UpdateLogRegistry.load();
            TexturedButtonBuilder updateLogButton = this.createButton(ModTextures.UPDATE_LOG, ModTexts.UPDATE_LOG);
            if (ClientConfiguration.INSTANCE != null && !ClientConfiguration.INSTANCE.getLastSeenUpdateLogVersion().equals(UpdateLogRegistry.getLatestVersion())) {
                updateLogButton.tooltip(new Component[]{ModTexts.UPDATE_LOG_NEW_TOOLTIP});
            }
            this.buttonBarRight.getChildren().add((Node)updateLogButton.action(ModScreenHandler::openUpdateLogScreen));
            this.buttonBarRight.getChildren().add(GuapiHelper.hBox(zoom -> {
                this.zoomResetButton = (TexturedButton)this.createButton(ModTextures.ZOOM_RESET, ModTexts.ZOOM_RESET).action(ScreenScalingManager.get()::restoreScale);
                zoom.add(this.zoomResetButton);
                this.zoomOutButton = (TexturedButton)this.createButton(ModTextures.ZOOM_OUT, ModTexts.ZOOM_OUT).action(ScreenScalingManager.get()::scaleDown);
                zoom.add(this.zoomOutButton);
                this.zoomLabel = (Label)((LabelBuilder)((LabelBuilder)GuapiHelper.label().prefWidth(25)).textAlign(GuapiHelper.CENTER)).padding(0, 3);
                zoom.add(this.zoomLabel);
                this.zoomInButton = (TexturedButton)this.createButton(ModTextures.ZOOM_IN, ModTexts.ZOOM_IN).action(ScreenScalingManager.get()::scaleUp);
                zoom.add(this.zoomInButton);
                ((HBoxBuilder)zoom.spacing(2)).align(GuapiHelper.CENTER);
            }));
            ((HBoxBuilder)buttons.spacing(20)).prefHeight(16);
        });
        return this.buttonBar;
    }

    protected abstract Node createEditor();

    protected Node createFooter() {
        return GuapiHelper.vBox(box -> {
            ((VBoxBuilder)box.spacing(4)).align(GuapiHelper.CENTER);
            box.add((Node)((LabelBuilder)GuapiHelper.label((Component)ModTexts.gui("cade_footer_short")).textAlign(GuapiHelper.CENTER)).prefHeight(12));
            box.add(GuapiHelper.hBox(footer -> {
                ((HBoxBuilder)footer.spacing(20)).align(GuapiHelper.CENTER);
                this.cancelButton = (Button)GuapiHelper.button((Component)ModTexts.CANCEL).prefWidth(90);
                footer.add(this.cancelButton);
                this.saveButton = (Button)((ButtonBuilder)GuapiHelper.button((Component)ModTexts.SAVE_EDIT).prefWidth(90)).visible(false);
                footer.add(this.saveButton);
                this.doneButton = (Button)GuapiHelper.button((Component)ModTexts.DONE).prefWidth(90);
                footer.add(this.doneButton);
            }));
        });
    }

    protected TexturedButtonBuilder createButton(ResourceLocation id, String tooltipText) {
        return this.createButton(id, GuapiHelper.translated(tooltipText));
    }

    protected TexturedButtonBuilder createButton(ResourceLocation id, MutableComponent tooltipText) {
        return (TexturedButtonBuilder)GuapiHelper.texturedButton(id, 16, 16, false).tooltip(new Component[]{tooltipText});
    }

    protected void onZoomUpdated() {
        this.zoomOutButton.setDisable(!ScreenScalingManager.get().canScaleDown());
        this.zoomLabel.setLabel((Component)GuapiHelper.text(ScreenScalingManager.get().getScale() == 0 ? "Auto" : Integer.toString(ScreenScalingManager.get().getScale())));
        this.zoomInButton.setDisable(!ScreenScalingManager.get().canScaleUp());
    }

    @Override
    public VBox getRoot() {
        return this.root;
    }

    public Label getHeaderLabel() {
        return this.headerLabel;
    }

    public TexturedToggleButton getCopyCommandButton() {
        return this.copyCommandButton;
    }

    public TexturedToggleButton getSaveVaultButton() {
        return this.saveVaultButton;
    }

    public TexturedButton getLoadVaultButton() {
        return this.loadVaultButton;
    }

    public TexturedButton getOpenEditorButton() {
        return this.openEditorButton;
    }

    public TexturedButton getOpenNBTEditorButton() {
        return this.openNBTEditorButton;
    }

    public TexturedButton getOpenSNBTEditorButton() {
        return this.openSNBTEditorButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getDoneButton() {
        return this.doneButton;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public void addSaveVaultButton(MutableComponent arg) {
        this.saveVaultButton = (TexturedToggleButton)((TexturedToggleButtonBuilder)GuapiHelper.texturedToggleButton(ModTextures.SAVE, 16, 16, false).tooltip(new Component[]{ModTexts.SAVE_VAULT})).action(() -> this.saveVaultButton.getTooltip().setAll((Collection<Component>)(this.saveVaultButton.isActive() ? Arrays.asList(ModTexts.savedVault(arg)) : Collections.singletonList(ModTexts.SAVE_VAULT))));
        this.editorButtons.getChildren().add(this.saveVaultButton);
    }

    public void addLoadVaultButton(Runnable action) {
        this.loadVaultButton = (TexturedButton)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.PASTE, 16, 16, false).tooltip(new Component[]{ModTexts.LOAD_VAULT})).action(action);
        this.editorButtons.getChildren().add(this.loadVaultButton);
    }

    public void addOpenEditorButton(Runnable action) {
        this.openEditorButton = (TexturedButton)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.EDITOR, 16, 16, false).tooltip(new Component[]{ModTexts.OPEN_EDITOR})).action(action);
        this.editorButtons.getChildren().add(this.openEditorButton);
    }

    public void addOpenNBTEditorButton(Runnable action) {
        this.openNBTEditorButton = (TexturedButton)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.NBT_EDITOR, 16, 16, false).tooltip(new Component[]{ModTexts.OPEN_NBT_EDITOR})).action(action);
        this.editorButtons.getChildren().add(this.openNBTEditorButton);
    }

    public void addOpenSNBTEditorButton(Runnable action) {
        this.openSNBTEditorButton = (TexturedButton)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.SNBT_EDITOR, 16, 16, false).tooltip(new Component[]{ModTexts.OPEN_SNBT_EDITOR})).action(action);
        this.editorButtons.getChildren().add(this.openSNBTEditorButton);
    }

    public void addCopyCommandButton(MutableComponent copyText, String copiedText) {
        this.copyCommandButton = (TexturedToggleButton)((TexturedToggleButtonBuilder)GuapiHelper.texturedToggleButton(ModTextures.COPY_COMMAND, 16, 16, false).tooltip(new Component[]{copyText})).action(() -> this.copyCommandButton.getTooltip().setAll((Collection<Component>)(this.copyCommandButton.isActive() ? Arrays.asList(ModTexts.commandCopied(copiedText)) : Collections.singletonList(copyText))));
        this.editorButtons.getChildren().add(this.copyCommandButton);
    }
}

