/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view.entry.item;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.EnumButton;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.builder.EnumButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.TextFieldBuilder;
import com.github.franckyi.guapi.api.node.builder.VBoxBuilder;
import com.github.franckyi.guapi.api.util.Predicates;
import com.github.rinorsi.cadeditor.client.ModTextures;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.AttributeModifierEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.EntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.network.chat.Component;

public class AttributeModifierEntryView
extends EntryView {
    private TextField attributeNameField;
    private TexturedButton attributeListButton;
    private EnumButton<AttributeModifierEntryModel.Slot> slotButton;
    private EnumButton<AttributeModifierEntryModel.Operation> operationButton;
    private TextField amountField;
    private Label attributePreviewLabel;

    @Override
    public void build() {
        super.build();
        this.operationButton.valueProperty().addListener(this::updateOperationTooltip);
        this.updateOperationTooltip();
    }

    private void updateOperationTooltip() {
        this.operationButton.getTooltip().setAll((Component[])new Component[]{this.operationButton.getValue().getTooltip()});
    }

    @Override
    protected Node createContent() {
        return GuapiHelper.vBox(content -> {
            content.add(GuapiHelper.hBox(top -> {
                this.attributeNameField = ((TextFieldBuilder)GuapiHelper.textField().prefHeight(16)).placeholder((Component)ModTexts.ATTRIBUTE_NAME);
                top.add(this.attributeNameField, 1);
                this.attributeListButton = (TexturedButton)GuapiHelper.texturedButton(ModTextures.SEARCH, 16, 16, false).tooltip(new Component[]{ModTexts.choose(ModTexts.ATTRIBUTE)});
                top.add(this.attributeListButton);
                this.attributePreviewLabel = (Label)((LabelBuilder)GuapiHelper.label().prefHeight(16)).visible(false);
                top.add(this.attributePreviewLabel);
                ((HBoxBuilder)top.align(GuapiHelper.CENTER)).spacing(2);
            }));
            content.add(GuapiHelper.hBox(bottom -> {
                this.slotButton = (EnumButton)((EnumButtonBuilder)GuapiHelper.enumButton(AttributeModifierEntryModel.Slot.values()).textFactory(AttributeModifierEntryModel.Slot::getText)).tooltip(new Component[]{ModTexts.SLOT});
                bottom.add(this.slotButton);
                this.operationButton = GuapiHelper.enumButton(AttributeModifierEntryModel.Operation.values()).textFactory(AttributeModifierEntryModel.Operation::getText);
                bottom.add(this.operationButton);
                this.amountField = (TextField)((TextFieldBuilder)((TextFieldBuilder)GuapiHelper.textField().validator(Predicates.IS_DOUBLE)).tooltip(new Component[]{ModTexts.AMOUNT})).prefHeight(16);
                bottom.add(this.amountField, 1);
                ((HBoxBuilder)bottom.align(GuapiHelper.CENTER)).spacing(2);
            }));
            ((VBoxBuilder)((VBoxBuilder)content.spacing(2)).align(GuapiHelper.CENTER)).fillWidth();
        });
    }

    public TextField getAttributeNameField() {
        return this.attributeNameField;
    }

    public TexturedButton getAttributeListButton() {
        return this.attributeListButton;
    }

    public EnumButton<AttributeModifierEntryModel.Slot> getSlotButton() {
        return this.slotButton;
    }

    public EnumButton<AttributeModifierEntryModel.Operation> getOperationButton() {
        return this.operationButton;
    }

    public TextField getAmountField() {
        return this.amountField;
    }

    public Label getAttributePreviewLabel() {
        return this.attributePreviewLabel;
    }
}

