/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view.entry.item;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.EnumButton;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.builder.EnumButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.TextFieldBuilder;
import com.github.franckyi.guapi.api.util.Predicates;
import com.github.rinorsi.cadeditor.client.ModTextures;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ToolRuleEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.EntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.network.chat.Component;

public class ToolRuleEntryView
extends EntryView {
    private Label ruleLabel;
    private TextField selectionField;
    private TexturedButton selectBlocksButton;
    private TexturedButton selectTagsButton;
    private TexturedButton deleteRuleButton;
    private TextField speedField;
    private EnumButton<ToolRuleEntryModel.DropBehavior> behaviorButton;

    @Override
    protected Node createContent() {
        return GuapiHelper.hBox(content -> {
            this.ruleLabel = ((LabelBuilder)((LabelBuilder)GuapiHelper.label().prefWidth(26)).prefHeight(16)).textAlign(GuapiHelper.CENTER_RIGHT);
            content.add(this.ruleLabel);
            content.add(GuapiHelper.hBox(selection -> {
                this.selectionField = ((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)GuapiHelper.textField().prefHeight(16)).prefWidth(0)).minWidth(60)).maxWidth(Integer.MAX_VALUE)).padding(0, 2)).placeholder((Component)ModTexts.gui("tool_rule_blocks_empty"));
                selection.add(this.selectionField, 1);
                ((HBoxBuilder)selection.spacing(4)).align(GuapiHelper.CENTER_LEFT);
            }), 1);
            this.speedField = ((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)GuapiHelper.textField().prefWidth(60)).prefHeight(16)).validator(value -> value == null || value.isBlank() || Predicates.IS_DOUBLE.test((String)value))).placeholder((Component)ModTexts.gui("tool_rule_speed"));
            content.add(this.speedField);
            this.behaviorButton = (EnumButton)((EnumButtonBuilder)GuapiHelper.enumButton(ToolRuleEntryModel.DropBehavior.values()).prefWidth(60)).prefHeight(16);
            content.add(this.behaviorButton);
            ((HBoxBuilder)content.spacing(6)).align(GuapiHelper.CENTER_LEFT);
        });
    }

    @Override
    public void build() {
        super.build();
        HBox buttonBox = this.getButtonBox();
        int resetIndex = buttonBox.getChildren().indexOf(this.getResetButton());
        if (resetIndex < 0) {
            resetIndex = buttonBox.getChildren().size();
        }
        this.selectBlocksButton = (TexturedButton)GuapiHelper.texturedButton(ModTextures.SEARCH, 16, 16, false).tooltip(new Component[]{ModTexts.choose(ModTexts.gui("tool_rule_blocks"))});
        this.selectTagsButton = (TexturedButton)GuapiHelper.texturedButton(ModTextures.SEARCH, 16, 16, false).tooltip(new Component[]{ModTexts.choose(ModTexts.gui("tool_rule_tags"))});
        this.deleteRuleButton = (TexturedButton)GuapiHelper.texturedButton(ModTextures.REMOVE, 16, 16, false).tooltip(new Component[]{ModTexts.REMOVE});
        buttonBox.getChildren().add(resetIndex, this.selectBlocksButton);
        buttonBox.getChildren().add(resetIndex + 1, this.selectTagsButton);
        buttonBox.getChildren().add(this.deleteRuleButton);
    }

    public TextField getSelectionField() {
        return this.selectionField;
    }

    public Label getRuleLabel() {
        return this.ruleLabel;
    }

    public TextField getSpeedField() {
        return this.speedField;
    }

    public EnumButton<ToolRuleEntryModel.DropBehavior> getBehaviorButton() {
        return this.behaviorButton;
    }

    public TexturedButton getSelectBlocksButton() {
        return this.selectBlocksButton;
    }

    public TexturedButton getSelectTagsButton() {
        return this.selectTagsButton;
    }

    public TexturedButton getDeleteRuleButton() {
        return this.deleteRuleButton;
    }
}

