/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.util;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import net.minecraft.client.Minecraft;

public final class ScreenScalingManager {
    private static final ScreenScalingManager INSTANCE = new ScreenScalingManager();
    private final IntegerProperty scaleProperty = IntegerProperty.create();
    private final ObservableIntegerValue scalePropertyReadOnly = ObservableIntegerValue.readOnly(this.scaleProperty);
    private final BooleanProperty canScaleBeResetProperty = BooleanProperty.create();
    private final ObservableBooleanValue canScaleBeResetPropertyReadOnly = ObservableBooleanValue.readOnly(this.canScaleBeResetProperty);

    private ScreenScalingManager() {
        this.scaleProperty().addListener(this::setScreenScale);
    }

    public static ScreenScalingManager get() {
        return INSTANCE;
    }

    public void setBaseScale(int value) {
        if (value != -1) {
            this.setScale(value);
        } else {
            this.restoreScale();
        }
    }

    public int getScale() {
        return this.scaleProperty().getValue();
    }

    public ObservableIntegerValue scaleProperty() {
        return this.scalePropertyReadOnly;
    }

    private void setScale(int scale) {
        this.scaleProperty.setValue(scale);
        this.canScaleBeResetProperty.setValue(true);
    }

    public ObservableBooleanValue canScaleBeResetProperty() {
        return this.canScaleBeResetPropertyReadOnly;
    }

    public int getScaleAndReset() {
        int res = this.canScaleBeResetProperty.getValue() ? this.getScale() : -1;
        this.restoreScale();
        this.resetScale();
        return res;
    }

    public void restoreScale() {
        this.setScale(this.getDefaultScale());
        this.canScaleBeResetProperty.setValue(false);
    }

    public void scaleUp() {
        if (this.getScale() >= this.getMaxScale()) {
            this.setScale(0);
        } else {
            this.setScale(this.getScale() + 1);
        }
    }

    public void scaleDown() {
        if (this.getScale() == 0) {
            this.setScale(this.getMaxScale());
        } else {
            this.setScale(this.getScale() - 1);
        }
    }

    public boolean canScaleUp() {
        return this.getScale() != 0;
    }

    public boolean canScaleDown() {
        return this.getScale() != 1;
    }

    public void refresh() {
        this.setScreenScale(this.getScale());
    }

    private Minecraft mc() {
        return Minecraft.getInstance();
    }

    private void resetScale() {
        this.mc().resizeDisplay();
    }

    private void setScreenScale(int value) {
        this.mc().getWindow().setGuiScale((double)this.mc().getWindow().calculateScale(value, this.mc().isEnforceUnicode()));
        this.mc().screen.resize(this.mc(), this.mc().getWindow().getGuiScaledWidth(), this.mc().getWindow().getGuiScaledHeight());
    }

    private int getDefaultScale() {
        return (Integer)this.mc().options.guiScale().get();
    }

    public int getMaxScale() {
        return this.mc().getWindow().calculateScale(0, this.mc().isEnforceUnicode());
    }
}

