/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.logic;

import com.github.rinorsi.cadeditor.common.CommonUtil;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.logic.PermissionLogic;
import com.github.rinorsi.cadeditor.common.network.BlockEditorPacket;
import com.github.rinorsi.cadeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.MainHandItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PlayerInventoryItemEditorPacket;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerEditorUpdateLogic {
    private static final Component VERIFICATION_FAILED = Component.literal((String)"Update verification failed; inventory re-synced. Please check the item.");
    private static final Logger LOGGER = LogManager.getLogger();

    private ServerEditorUpdateLogic() {
    }

    public static void onMainHandItemEditorUpdate(ServerPlayer player, MainHandItemEditorPacket.Update response) {
        ItemStack normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        try {
            int hotbarIdx = player.getInventory().selected;
            player.getInventory().setItem(hotbarIdx, normalizedStack.copy());
            player.setItemInHand(InteractionHand.MAIN_HAND, normalizedStack.copy());
            player.getInventory().setChanged();
            if (player.containerMenu != null) {
                player.containerMenu.broadcastChanges();
            }
            ServerEditorUpdateLogic.syncMainHand(player);
            ServerEditorUpdateLogic.queueMainHandVerification(player, normalizedStack);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply main hand item update for {}", (Object)player.getGameProfile().getName(), (Object)e);
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onPlayerInventoryItemEditorUpdate(ServerPlayer player, PlayerInventoryItemEditorPacket.Update response) {
        ItemStack normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        try {
            player.getInventory().setItem(response.getSlot(), normalizedStack.copy());
            player.getInventory().setChanged();
            if (player.containerMenu != null) {
                player.containerMenu.broadcastChanges();
            }
            ServerEditorUpdateLogic.syncInventorySlot(player, response.getSlot());
            ServerEditorUpdateLogic.queueInventoryVerification(player, response.getSlot(), normalizedStack);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply inventory item update for {} (slot {})", (Object)player.getGameProfile().getName(), (Object)response.getSlot(), (Object)e);
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onBlockInventoryItemEditorUpdate(ServerPlayer player, BlockInventoryItemEditorPacket.Update response) {
        ItemStack normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        Level level = player.level();
        BlockPos pos = response.getBlockPos();
        BlockState state = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            try {
                container.setItem(response.getSlot(), normalizedStack.copy());
                container.setChanged();
                level.sendBlockUpdated(pos, state, state, 2);
                CommonUtil.showItemUpdateSuccess((Player)player, normalizedStack);
                if (player.containerMenu != null) {
                    player.containerMenu.broadcastChanges();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update block inventory at {} (slot {}) for {}", (Object)pos, (Object)response.getSlot(), (Object)player.getGameProfile().getName(), (Object)e);
                CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)Component.translatable((String)"cadeditor.message.no_target_found", (Object[])new Object[]{ModTexts.ITEM}));
        }
    }

    public static void onEntityInventoryItemEditorUpdate(ServerPlayer player, EntityInventoryItemEditorPacket.Update response) {
        ItemStack normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        Level level = player.level();
        Entity entity = level.getEntity(response.getEntityId());
        if (entity instanceof Container) {
            Container container = (Container)entity;
            try {
                container.setItem(response.getSlot(), normalizedStack.copy());
                container.setChanged();
                CommonUtil.showItemUpdateSuccess((Player)player, normalizedStack);
                if (player.containerMenu != null) {
                    player.containerMenu.broadcastChanges();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update entity inventory for entity {} (slot {})", (Object)response.getEntityId(), (Object)response.getSlot(), (Object)e);
                CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showItemUpdateFailure((Player)player, normalizedStack, (Component)Component.translatable((String)"cadeditor.message.no_target_found", (Object[])new Object[]{ModTexts.ITEM}));
        }
    }

    public static void onBlockEditorUpdate(ServerPlayer player, BlockEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.BLOCK);
            return;
        }
        Level level = player.level();
        BlockPos pos = update.getBlockPos();
        BlockState oldState = level.getBlockState(pos);
        try {
            level.setBlock(pos, update.getBlockState(), 3);
            BlockState currentState = level.getBlockState(pos);
            if (update.getTag() != null) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity == null) {
                    CommonUtil.showTargetError((Player)player, ModTexts.BLOCK);
                    return;
                }
                blockEntity.loadWithComponents(update.getTag(), (HolderLookup.Provider)player.registryAccess());
                blockEntity.setChanged();
            }
            level.sendBlockUpdated(pos, oldState, currentState, 2);
            CommonUtil.showUpdateSuccess((Player)player, ModTexts.BLOCK);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update block at {} for {}", (Object)pos, (Object)player.getGameProfile().getName(), (Object)e);
            CommonUtil.showMessage((Player)player, (Component)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onEntityEditorUpdate(ServerPlayer player, EntityEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ENTITY);
            return;
        }
        Level level = player.level();
        Entity entity = level.getEntity(update.getEntityId());
        if (entity != null) {
            try {
                entity.load(update.getTag());
                Level level2 = entity.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.getChunkSource().broadcastAndSend(entity, (Packet)new ClientboundSetEntityDataPacket(entity.getId(), entity.getEntityData().getNonDefaultValues()));
                }
                CommonUtil.showUpdateSuccess((Player)player, ModTexts.ENTITY);
            }
            catch (Exception e) {
                LOGGER.error("Failed to update entity {} for {}", (Object)update.getEntityId(), (Object)player.getGameProfile().getName(), (Object)e);
                CommonUtil.showMessage((Player)player, (Component)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ENTITY);
        }
    }

    private static int toMenuSlotIndex(int invIndex) {
        return invIndex >= 0 && invIndex < 9 ? 36 + invIndex : invIndex;
    }

    private static void syncMainHand(ServerPlayer player) {
        AbstractContainerMenu menu = player.containerMenu != null ? player.containerMenu : player.inventoryMenu;
        int stateId = menu.incrementStateId();
        int hotbarIdx = player.getInventory().selected;
        int menuSlot = 36 + hotbarIdx;
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, stateId, menuSlot, player.getMainHandItem().copy()));
        player.connection.send((Packet)new ClientboundSetEquipmentPacket(player.getId(), List.of(Pair.of((Object)EquipmentSlot.MAINHAND, (Object)player.getMainHandItem().copy()))));
    }

    private static void syncInventorySlot(ServerPlayer player, int invIndex) {
        AbstractContainerMenu menu = player.containerMenu != null ? player.containerMenu : player.inventoryMenu;
        int stateId = menu.incrementStateId();
        int menuSlot = ServerEditorUpdateLogic.toMenuSlotIndex(invIndex);
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, stateId, menuSlot, player.getInventory().getItem(invIndex).copy()));
    }

    private static void forceInventorySync(ServerPlayer player) {
        AbstractContainerMenu menu = player.containerMenu != null ? player.containerMenu : player.inventoryMenu;
        int stateId = menu.incrementStateId();
        player.connection.send((Packet)new ClientboundContainerSetContentPacket(menu.containerId, stateId, menu.getItems(), menu.getCarried()));
        player.connection.send((Packet)new ClientboundSetEquipmentPacket(player.getId(), List.of(Pair.of((Object)EquipmentSlot.MAINHAND, (Object)player.getMainHandItem().copy()), Pair.of((Object)EquipmentSlot.OFFHAND, (Object)player.getOffhandItem().copy()))));
    }

    private static void queueMainHandVerification(ServerPlayer player, ItemStack expected) {
        ItemStack expectedCopy = expected.copy();
        ServerEditorUpdateLogic.scheduleVerification(player, () -> {
            ItemStack current = player.getMainHandItem();
            if (ServerEditorUpdateLogic.areStacksEquivalent(current, expectedCopy)) {
                CommonUtil.showItemUpdateSuccess((Player)player, expectedCopy);
            } else {
                ServerEditorUpdateLogic.logStackDiff("MainHand", current, expectedCopy, player);
                ServerEditorUpdateLogic.forceInventorySync(player);
                CommonUtil.showItemUpdateFailure((Player)player, expectedCopy, VERIFICATION_FAILED);
            }
        });
    }

    private static void queueInventoryVerification(ServerPlayer player, int slot, ItemStack expected) {
        int size = player.getInventory().getContainerSize();
        if (slot < 0 || slot >= size) {
            CommonUtil.showItemUpdateFailure((Player)player, expected, (Component)Component.literal((String)("Invalid slot: " + slot)));
            return;
        }
        ItemStack expectedCopy = expected.copy();
        ServerEditorUpdateLogic.scheduleVerification(player, () -> {
            ItemStack current = player.getInventory().getItem(slot);
            if (ServerEditorUpdateLogic.areStacksEquivalent(current, expectedCopy)) {
                CommonUtil.showItemUpdateSuccess((Player)player, expectedCopy);
            } else {
                ServerEditorUpdateLogic.logStackDiff("InventorySlot", current, expectedCopy, player);
                ServerEditorUpdateLogic.forceInventorySync(player);
                CommonUtil.showItemUpdateFailure((Player)player, expectedCopy, VERIFICATION_FAILED);
            }
        });
    }

    private static void scheduleVerification(ServerPlayer player, Runnable action) {
        MinecraftServer server = player.serverLevel().getServer();
        server.execute(() -> server.execute(action));
    }

    private static void logStackDiff(String where, ItemStack actual, ItemStack expected, ServerPlayer player) {
        try {
            NbtOps ops = NbtOps.INSTANCE;
            Tag actualData = ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)actual).result().orElse(null);
            Tag expectedData = ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)expected).result().orElse(null);
            LOGGER.warn("[{}] stack mismatch for {}. Actual={}, Expected={}", (Object)where, (Object)player.getGameProfile().getName(), (Object)actualData, (Object)expectedData);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to diff stacks for {}", (Object)player.getGameProfile().getName(), (Object)ex);
        }
    }

    private static ItemStack normalize(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        NbtOps ops = NbtOps.INSTANCE;
        return ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)input).result().flatMap(data -> ItemStack.CODEC.parse((DynamicOps)ops, data).result()).orElse(input.copy());
    }

    private static boolean areStacksEquivalent(ItemStack a, ItemStack b) {
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return a.getCount() == b.getCount() && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }
}

