/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorRequest;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorResponse;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorUpdate;
import com.github.rinorsi.cadeditor.common.network.InventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.ItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public final class BlockInventoryItemEditorPacket
extends InventoryItemEditorPacket {

    public static class Update
    extends InventoryItemEditorPacket.Update<RequestData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, ItemStack itemStack) {
            super((RequestData)response.getRequestData(), new ItemEditorPacket.ResponseData(itemStack));
        }

        public BlockPos getBlockPos() {
            return ((RequestData)this.getRequestData()).getBlockPos();
        }
    }

    public static class Response
    extends InventoryItemEditorPacket.Response<RequestData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, ItemStack item) {
            super(request, hasPermission, new ItemEditorPacket.ResponseData(item));
        }
    }

    public static class Request
    extends InventoryItemEditorPacket.Request<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, int slot, BlockPos blockPos) {
            super(editorType, new RequestData(slot, blockPos));
        }

        public BlockPos getBlockPos() {
            return ((RequestData)this.getRequestData()).getBlockPos();
        }
    }

    public static class RequestData
    extends InventoryItemEditorPacket.RequestData {
        public static final PacketSerializer<RequestData> SERIALIZER = new InventoryItemEditorPacket.RequestData.Serializer<RequestData>(){

            @Override
            public void write(RequestData obj, FriendlyByteBuf buf) {
                super.write(obj, buf);
                buf.writeBlockPos(obj.getBlockPos());
            }

            @Override
            public void read(RequestData obj, FriendlyByteBuf buf) {
                super.read(obj, buf);
                obj.setBlockPos(buf.readBlockPos());
            }

            @Override
            public RequestData createInstance() {
                return new RequestData();
            }
        };
        private BlockPos blockPos;

        private RequestData() {
        }

        public RequestData(int slot, BlockPos blockPos) {
            super(slot);
            this.blockPos = blockPos;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }
    }
}

