/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorRequest;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorResponse;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorUpdate;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class EntityEditorPacket {

    public static class Update
    extends AbstractEditorUpdate<RequestData, ResponseData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, CompoundTag tag) {
            super((RequestData)response.getRequestData(), new ResponseData(tag));
        }

        public int getEntityId() {
            return ((RequestData)this.getRequestData()).entityId();
        }

        public CompoundTag getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Response
    extends AbstractEditorResponse<RequestData, ResponseData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, CompoundTag tag) {
            super(request, hasPermission, new ResponseData(tag));
        }

        public CompoundTag getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Request
    extends AbstractEditorRequest<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, int entityId) {
            super(editorType, new RequestData(entityId));
        }

        public int getEntityId() {
            return ((RequestData)this.getRequestData()).entityId();
        }
    }

    public record ResponseData(CompoundTag tag) {
        public static final PacketSerializer<ResponseData> SERIALIZER = new PacketSerializer<ResponseData>(){

            @Override
            public void write(ResponseData obj, FriendlyByteBuf buf) {
                buf.writeNbt((Tag)obj.tag());
            }

            @Override
            public ResponseData read(FriendlyByteBuf buf) {
                return new ResponseData(buf.readNbt());
            }
        };
    }

    public record RequestData(int entityId) {
        public static final PacketSerializer<RequestData> SERIALIZER = new PacketSerializer<RequestData>(){

            @Override
            public void write(RequestData obj, FriendlyByteBuf buf) {
                buf.writeVarInt(obj.entityId());
            }

            @Override
            public RequestData read(FriendlyByteBuf buf) {
                return new RequestData(buf.readVarInt());
            }
        };
    }
}

