/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorRequest;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorResponse;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorUpdate;
import com.github.rinorsi.cadeditor.common.network.InventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.ItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public final class EntityInventoryItemEditorPacket
extends InventoryItemEditorPacket {

    public static class Update
    extends InventoryItemEditorPacket.Update<RequestData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, ItemStack itemStack) {
            super((RequestData)response.getRequestData(), new ItemEditorPacket.ResponseData(itemStack));
        }

        public int getEntityId() {
            return ((RequestData)this.getRequestData()).getEntityId();
        }
    }

    public static class Response
    extends InventoryItemEditorPacket.Response<RequestData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, ItemStack item) {
            super(request, hasPermission, new ItemEditorPacket.ResponseData(item));
        }
    }

    public static class Request
    extends InventoryItemEditorPacket.Request<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, int slot, int entityId) {
            super(editorType, new RequestData(slot, entityId));
        }

        public int getEntityId() {
            return ((RequestData)this.getRequestData()).getEntityId();
        }
    }

    public static class RequestData
    extends InventoryItemEditorPacket.RequestData {
        public static final PacketSerializer<RequestData> SERIALIZER = new InventoryItemEditorPacket.RequestData.Serializer<RequestData>(){

            @Override
            public void write(RequestData obj, FriendlyByteBuf buf) {
                super.write(obj, buf);
                buf.writeVarInt(obj.getEntityId());
            }

            @Override
            public void read(RequestData obj, FriendlyByteBuf buf) {
                super.read(obj, buf);
                obj.setEntityId(buf.readVarInt());
            }

            @Override
            public RequestData createInstance() {
                return new RequestData();
            }
        };
        private int entityId;

        private RequestData() {
        }

        public RequestData(int slot, int entityId) {
            super(slot);
            this.entityId = entityId;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public void setEntityId(int entityId) {
            this.entityId = entityId;
        }
    }
}

