/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.network.AbstractEditorRequest;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorResponse;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorUpdate;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public abstract class ItemEditorPacket {

    protected static abstract class Update<REQ>
    extends AbstractEditorUpdate<REQ, ResponseData> {
        protected Update() {
        }

        protected Update(REQ requestData, ResponseData responseData) {
            super(requestData, responseData);
        }

        public ItemStack getItemStack() {
            return ((ResponseData)this.getResponseData()).itemStack();
        }
    }

    protected static abstract class Response<REQ>
    extends AbstractEditorResponse<REQ, ResponseData> {
        protected Response() {
        }

        protected Response(AbstractEditorRequest<REQ> request, boolean permission, ResponseData responseData) {
            super(request, permission, responseData);
        }

        public ItemStack getItemStack() {
            return ((ResponseData)this.getResponseData()).itemStack();
        }
    }

    protected record ResponseData(ItemStack itemStack) {
        public static final PacketSerializer<ResponseData> SERIALIZER = new PacketSerializer<ResponseData>(){

            @Override
            public void write(ResponseData obj, FriendlyByteBuf buf) {
                if (!(buf instanceof RegistryFriendlyByteBuf)) {
                    throw new IllegalStateException("Expected registry-friendly buffer for item stack serialization");
                }
                RegistryFriendlyByteBuf registryBuf = (RegistryFriendlyByteBuf)buf;
                ItemStack.STREAM_CODEC.encode((Object)registryBuf, (Object)obj.itemStack());
            }

            @Override
            public ResponseData read(FriendlyByteBuf buf) {
                if (buf instanceof RegistryFriendlyByteBuf) {
                    RegistryFriendlyByteBuf registryBuf = (RegistryFriendlyByteBuf)buf;
                    return new ResponseData((ItemStack)ItemStack.STREAM_CODEC.decode((Object)registryBuf));
                }
                throw new IllegalStateException("Expected registry-friendly buffer for item stack deserialization");
            }
        };
    }
}

