/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.mixin;

import com.github.franckyi.guapi.base.theme.vanilla.delegate.AbstractVanillaListNodeSkinDelegate;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSelectionList.class})
public abstract class AbstractSelectionListMixin<E> {
    @Shadow
    protected int headerHeight;
    @Shadow
    @Final
    protected int itemHeight;

    @Shadow
    public abstract double getScrollAmount();

    @Shadow
    protected abstract int getScrollbarPosition();

    @Shadow
    protected abstract int getItemCount();

    @Shadow
    public abstract List<E> children();

    @Inject(method={"getEntryAtPosition(DD)Lnet/minecraft/client/gui/components/AbstractSelectionList$Entry;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEntryAtPositionFix(double x, double y, CallbackInfoReturnable<E> cir) {
        if (!AbstractVanillaListNodeSkinDelegate.class.isInstance(this)) {
            return;
        }
        Object node = ((AbstractVanillaListNodeSkinDelegate)AbstractVanillaListNodeSkinDelegate.class.cast(this)).getNode();
        int k = node.getLeft();
        int l = node.getRight();
        int m = Mth.floor((double)(y - (double)node.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int n = m / this.itemHeight;
        cir.setReturnValue(x < (double)this.getScrollbarPosition() && x >= (double)k && x <= (double)l && n >= 0 && m >= 0 && n < this.getItemCount() ? this.children().get(n) : null);
    }
}

