/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import com.github.franckyi.databindings.base.event.ObservableListChangeEventImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class ObservableArrayList<E>
extends ArrayList<E>
implements ObservableList<E> {
    private static final long serialVersionUID = 1L;
    protected final transient List<ObservableListChangeListener<? super E>> listeners = new ArrayList<ObservableListChangeListener<? super E>>();

    public ObservableArrayList() {
    }

    public ObservableArrayList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public E set(int index, E element) {
        if (!this.canAdd(element)) {
            return null;
        }
        E removed = super.set(index, element);
        if (removed != element) {
            this.notify(ObservableListChangeEventImpl.builder().replace(index, removed, element).build());
        }
        return removed;
    }

    @Override
    public boolean add(E e) {
        if (!this.canAdd(e)) {
            return false;
        }
        super.add(e);
        this.notify(ObservableListChangeEventImpl.builder().add(this.size() - 1, e).build());
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (!this.canAdd(element)) {
            return;
        }
        super.add(index, element);
        this.notify(ObservableListChangeEventImpl.builder().add(index, element).build());
    }

    @Override
    public E remove(int index) {
        Object removed = super.remove(index);
        this.notify(ObservableListChangeEventImpl.builder().remove(index, removed).build());
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0 && super.remove(o)) {
            this.notify(ObservableListChangeEventImpl.builder().remove(index, o).build());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ObservableListChangeEventImpl event = ObservableListChangeEventImpl.builder().clear(this).build();
        super.clear();
        this.notify(event);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        c = this.canAddAll(c);
        int initialSize = this.size();
        if (super.addAll(c)) {
            this.notify(ObservableListChangeEventImpl.builder().addAll(initialSize, c).build());
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        if (super.addAll(index, c = this.canAddAll(c))) {
            this.notify(ObservableListChangeEventImpl.builder().addAll(index, c).build());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        ArrayList copy = new ArrayList(this);
        if (super.removeAll(c)) {
            this.computeRemoved(copy);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        ArrayList copy = new ArrayList(this);
        if (super.retainAll(c)) {
            this.computeRemoved(copy);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        ArrayList copy = new ArrayList(this);
        if (super.removeIf(filter)) {
            this.computeRemoved(copy);
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        ArrayList copy = new ArrayList(this);
        super.replaceAll(operator);
        ObservableListChangeEventImpl.Builder builder = ObservableListChangeEventImpl.builder();
        for (int i = 0; i < copy.size(); ++i) {
            Object newValue;
            Object oldValue = copy.get(i);
            if (Objects.equals(oldValue, newValue = this.get(i))) continue;
            builder.replace(i, oldValue, newValue);
        }
        ObservableListChangeEventImpl event = builder.build();
        if (!event.getAllChanged().isEmpty()) {
            this.notify(event);
        }
    }

    @Override
    public void addListener(ObservableListChangeListener<? super E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableListChangeListener<? super E> listener) {
        this.listeners.remove(listener);
    }

    protected boolean canAdd(E element) {
        return true;
    }

    protected Collection<? extends E> canAddAll(Collection<? extends E> c) {
        return c.stream().filter(this::canAdd).toList();
    }

    protected void computeRemoved(List<E> copy) {
        ObservableListChangeEventImpl.Builder<E> builder = ObservableListChangeEventImpl.builder();
        int index = 0;
        for (int copyIndex = 0; copyIndex < copy.size(); ++copyIndex) {
            Object newValue;
            E oldValue = copy.get(copyIndex);
            Object v0 = newValue = index < this.size() ? this.get(index) : null;
            if (oldValue != newValue) {
                builder.remove(copyIndex, oldValue);
                continue;
            }
            if (++index == this.size()) break;
        }
        this.notify(builder.build());
    }

    protected void notify(ObservableListChangeEventImpl<E> event) {
        if (!event.getAllChanged().isEmpty()) {
            this.listeners.forEach((? super T listener) -> listener.onListChange(event));
        }
    }
}

