/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api;

import com.github.franckyi.guapi.api.GuapiExceptionHandler;
import com.github.franckyi.guapi.api.NodeFactory;
import com.github.franckyi.guapi.api.ScreenHandler;
import com.github.franckyi.guapi.api.theme.Theme;
import com.github.franckyi.guapi.api.util.DebugMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Guapi {
    public static final Marker LOG_MARKER = MarkerManager.getMarker((String)"GUAPI");
    private static final Map<String, Theme> themeRegistry = new HashMap<String, Theme>();
    private static Theme theme;
    private static NodeFactory nodeFactory;
    private static ScreenHandler screenHandler;
    private static DebugMode debugMode;
    private static GuapiExceptionHandler exceptionHandler;
    private static Logger logger;

    public static Theme getTheme() {
        return theme;
    }

    public static void setTheme(String theme) {
        if (!themeRegistry.containsKey(theme)) {
            Optional defaultTheme = themeRegistry.keySet().stream().findFirst();
            if (defaultTheme.isPresent()) {
                String defaultThemeName = (String)defaultTheme.get();
                Guapi.getDefaultLogger().error(LOG_MARKER, "\"{}\" theme isn't registered, using default \"{}\" theme", (Object)theme, (Object)defaultThemeName);
                theme = defaultThemeName;
            } else {
                Guapi.getDefaultLogger().error(LOG_MARKER, "\"{}\" theme isn't registered, and no other theme is registered!", (Object)theme);
            }
        }
        Guapi.theme = themeRegistry.get(theme);
    }

    public static void registerTheme(String name, Theme theme) {
        themeRegistry.put(name, theme);
    }

    public static NodeFactory getNodeFactory() {
        return nodeFactory;
    }

    public static void setNodeFactory(NodeFactory nodeFactory) {
        Guapi.nodeFactory = nodeFactory;
    }

    public static ScreenHandler getScreenHandler() {
        return screenHandler;
    }

    public static void setScreenHandler(ScreenHandler screenHandler) {
        Guapi.screenHandler = screenHandler;
    }

    public static DebugMode getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(DebugMode debugMode) {
        Guapi.debugMode = debugMode == null ? DebugMode.NONE : debugMode;
    }

    public static void setExceptionHandler(GuapiExceptionHandler exceptionHandler) {
        Guapi.exceptionHandler = exceptionHandler;
    }

    public static GuapiExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    public static void setDefaultLogger(Logger logger) {
        Guapi.logger = logger;
    }

    public static Logger getDefaultLogger() {
        return logger;
    }

    static {
        debugMode = DebugMode.NONE;
        exceptionHandler = GuapiExceptionHandler.NONE;
    }
}

