/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.util;

import com.github.franckyi.guapi.api.EventTarget;
import com.github.franckyi.guapi.api.event.KeyEvent;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.event.MouseDragEvent;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.event.MouseScrollEvent;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.event.TypeEvent;
import java.util.Objects;
import java.util.function.BiConsumer;

public record ScreenEventType<E extends ScreenEvent>(String name, boolean mouseEvent, BiConsumer<EventTarget, E> onEvent) {
    public static final ScreenEventType<MouseButtonEvent> MOUSE_CLICKED = new ScreenEventType<MouseButtonEvent>("MOUSE_CLICKED", true, EventTarget::mouseClicked);
    public static final ScreenEventType<MouseButtonEvent> MOUSE_RELEASED = new ScreenEventType<MouseButtonEvent>("MOUSE_RELEASED", true, EventTarget::mouseReleased);
    public static final ScreenEventType<MouseDragEvent> MOUSE_DRAGGED = new ScreenEventType<MouseDragEvent>("MOUSE_DRAGGED", false, EventTarget::mouseDragged);
    public static final ScreenEventType<MouseScrollEvent> MOUSE_SCOLLED = new ScreenEventType<MouseScrollEvent>("MOUSE_SCOLLED", true, EventTarget::mouseScrolled);
    public static final ScreenEventType<KeyEvent> KEY_PRESSED = new ScreenEventType<KeyEvent>("KEY_PRESSED", false, EventTarget::keyPressed);
    public static final ScreenEventType<KeyEvent> KEY_RELEASED = new ScreenEventType<KeyEvent>("KEY_RELEASED", false, EventTarget::keyReleased);
    public static final ScreenEventType<TypeEvent> CHAR_TYPED = new ScreenEventType<TypeEvent>("CHAR_TYPED", false, EventTarget::charTyped);
    public static final ScreenEventType<MouseEvent> MOUSE_MOVED = new ScreenEventType<MouseEvent>("MOUSE_MOVED", true, EventTarget::mouseMoved);
    public static final ScreenEventType<MouseButtonEvent> ACTION = new ScreenEventType<MouseButtonEvent>("ACTION", false, EventTarget::action);

    public String getName() {
        return this.name;
    }

    public boolean isMouseEvent() {
        return this.mouseEvent;
    }

    public <EE extends MouseEvent> void ifMouseEvent(E event, BiConsumer<ScreenEventType<EE>, EE> thenDo, Runnable elseDo) {
        if (this.mouseEvent) {
            thenDo.accept(this, (MouseEvent)event);
        } else {
            elseDo.run();
        }
    }

    public void onEvent(EventTarget node, E event) {
        this.onEvent.accept(node, event);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenEventType that = (ScreenEventType)o;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }
}

