/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.event.TypeEvent;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.base.node.AbstractLabeled;
import java.util.function.Predicate;
import net.minecraft.class_2561;

public abstract class AbstractTextField
extends AbstractLabeled
implements TextField {
    private final StringProperty textProperty = StringProperty.create("");
    private final IntegerProperty maxLengthProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final ObjectProperty<Predicate<String>> validatorProperty = ObjectProperty.create(s -> true);
    private final BooleanProperty validationForcedProperty = BooleanProperty.create();
    private final ObservableBooleanValue validProperty;
    private final ObjectProperty<TextField.TextRenderer> textRendererProperty = ObjectProperty.create();
    private final IntegerProperty cursorPositionProperty = IntegerProperty.create();
    private final IntegerProperty highlightPositionProperty = IntegerProperty.create();
    private final ObjectProperty<TextField.TextFieldEventListener> onTextUpdateProperty = ObjectProperty.create();
    private final ObservableList<String> suggestions = ObservableList.create();
    private final BooleanProperty suggestedProperty = BooleanProperty.create();
    private final ObservableBooleanValue suggestedPropertyReadOnly = ObservableBooleanValue.readOnly(this.suggestedProperty);
    private final ObjectProperty<class_2561> placeholderProperty = ObjectProperty.create(GuapiHelper.EMPTY_TEXT);

    protected AbstractTextField() {
        this("");
    }

    protected AbstractTextField(String value) {
        this((class_2561)GuapiHelper.EMPTY_TEXT, value);
    }

    protected AbstractTextField(String label, String value) {
        this((class_2561)GuapiHelper.text(label), value);
    }

    protected AbstractTextField(class_2561 label, String value) {
        super(label);
        this.validProperty = ObservableBooleanValue.observe(() -> this.getValidator().test(this.getText()), this.validatorProperty(), this.textProperty());
        this.setText(value);
        this.textProperty().addListener(this::updateCursorPos);
        this.textProperty().addListener(this::updateSuggested);
        this.getSuggestions().addListener(this::updateSuggested);
        this.focusedProperty().addListener(this::resetSelection);
    }

    @Override
    public StringProperty textProperty() {
        return this.textProperty;
    }

    @Override
    public IntegerProperty maxLengthProperty() {
        return this.maxLengthProperty;
    }

    @Override
    public ObjectProperty<Predicate<String>> validatorProperty() {
        return this.validatorProperty;
    }

    @Override
    public BooleanProperty validationForcedProperty() {
        return this.validationForcedProperty;
    }

    @Override
    public ObservableBooleanValue validProperty() {
        return this.validProperty;
    }

    @Override
    public ObjectProperty<TextField.TextRenderer> textRendererProperty() {
        return this.textRendererProperty;
    }

    @Override
    public IntegerProperty cursorPositionProperty() {
        return this.cursorPositionProperty;
    }

    @Override
    public IntegerProperty highlightPositionProperty() {
        return this.highlightPositionProperty;
    }

    @Override
    public ObjectProperty<TextField.TextFieldEventListener> onTextUpdateProperty() {
        return this.onTextUpdateProperty;
    }

    @Override
    public ObservableList<String> getSuggestions() {
        return this.suggestions;
    }

    @Override
    public ObservableBooleanValue suggestedProperty() {
        return this.suggestedPropertyReadOnly;
    }

    @Override
    public ObjectProperty<class_2561> placeholderProperty() {
        return this.placeholderProperty;
    }

    @Override
    public void charTyped(TypeEvent event) {
        event.consume();
    }

    private void updateCursorPos(String text) {
        if (text == null) {
            this.setCursorPosition(0);
            this.setHighlightPosition(0);
        } else {
            if (this.getCursorPosition() > text.length()) {
                this.setCursorPosition(this.getText().length());
            }
            if (this.getHighlightPosition() > text.length()) {
                this.setHighlightPosition(this.getText().length());
            }
        }
    }

    private void updateSuggested() {
        this.suggestedProperty.setValue(this.getSuggestions().contains(this.getText()));
    }

    private void resetSelection() {
        this.setHighlightPosition(this.getCursorPosition());
    }
}

