/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.RenderHelper;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.theme.Skin;
import com.github.franckyi.guapi.api.util.DebugMode;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.rinorsi.cadeditor.client.debug.DebugLog;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public abstract class AbstractSkin<N extends Node>
implements Skin<N> {
    private final int debugColor = new Random().nextInt(0x1000000) + Integer.MIN_VALUE;
    private static final Map<Node, Integer> NODE_IDS = new ConcurrentHashMap<Node, Integer>();
    private static final AtomicInteger NODE_ID_SEQ = new AtomicInteger();

    protected AbstractSkin() {
    }

    @Override
    public boolean preRender(N node, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        return false;
    }

    @Override
    public void render(N node, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(node, guiGraphics);
    }

    @Override
    public void postRender(N node, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        DebugMode mode = Guapi.getDebugMode();
        if (mode == DebugMode.UI) {
            DebugLog.ui(this.nodeDebugKey(node), () -> this.describeNode(node, mouseX, mouseY));
            this.renderDebug(node, guiGraphics);
        }
        if (!node.getTooltip().isEmpty() && node.isHovered()) {
            RenderHelper.drawTooltip(guiGraphics, node.getTooltip(), mouseX, mouseY);
        }
    }

    @Override
    public <E extends ScreenEvent> void onEvent(ScreenEventType<E> type, E event) {
        type.onEvent(this, event);
    }

    protected void renderDebug(N node, class_332 guiGraphics) {
        RenderHelper.drawRectangle(guiGraphics, node.getLeft(), node.getTop(), node.getRight(), node.getBottom(), this.debugColor);
        if (node.getHeight() > 20) {
            int id = this.nodeId((Node)node);
            String label = "#" + id + " " + node.getClass().getSimpleName();
            RenderHelper.drawString(guiGraphics, (class_2561)class_2561.method_43470((String)label), node.getLeft() + 2, node.getTop() + 2, -1, true);
        }
    }

    protected void renderBackground(N node, class_332 guiGraphics) {
        RenderHelper.fillRectangle(guiGraphics, node.getLeft(), node.getTop(), node.getRight(), node.getBottom(), node.getBackgroundColor());
    }

    private String nodeDebugKey(N node) {
        return node.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(node));
    }

    private String describeNode(N node, int mouseX, int mouseY) {
        int id = this.nodeId((Node)node);
        String parent = node.getParent() != null ? node.getParent().getClass().getSimpleName() : "<root>";
        String scene = node.getScene() != null ? node.getScene().getClass().getSimpleName() : "<none>";
        String type = node.getClass().getName();
        return String.format("id=%d type=%s parent=%s scene=%s bounds=[%d,%d -> %d,%d] size[w=%d,h=%d pref=%dx%d computed=%dx%d] hovered=%s visible=%s mouse=(%d,%d)", id, type, parent, scene, node.getLeft(), node.getTop(), node.getRight(), node.getBottom(), node.getWidth(), node.getHeight(), node.getPrefWidth(), node.getPrefHeight(), node.getComputedWidth(), node.getComputedHeight(), node.isHovered(), node.isVisible(), mouseX, mouseY);
    }

    private int nodeId(Node node) {
        return NODE_IDS.computeIfAbsent(node, n -> NODE_ID_SEQ.incrementAndGet());
    }
}

