/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.Color;
import com.github.franckyi.guapi.api.RenderHelper;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.event.MouseDragEvent;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.event.MouseScrollEvent;
import com.github.franckyi.guapi.api.node.ListNode;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVanillaListNodeSkinDelegate<N extends ListNode<E>, E, T extends NodeEntry<N, E, T>>
extends class_350<T>
implements VanillaWidgetSkinDelegate {
    protected final N node;
    protected boolean shouldRefreshSize = true;
    protected boolean shouldRefreshList = true;
    protected boolean shouldScrollTo = false;
    protected boolean shouldChangeFocus = false;

    public AbstractVanillaListNodeSkinDelegate(N node) {
        super(class_310.method_1551(), 0, 0, 0, node.getItemHeight());
        this.node = node;
        Runnable rs = this::shouldRefreshSize;
        node.xProperty().addListener(rs);
        node.yProperty().addListener(rs);
        node.baseXProperty().addListener(rs);
        node.baseYProperty().addListener(rs);
        node.widthProperty().addListener(rs);
        node.heightProperty().addListener(rs);
        node.fullWidthProperty().addListener(rs);
        node.fullHeightProperty().addListener(rs);
        node.rootProperty().addListener(this::shouldRefreshList);
        node.scrollToProperty().addListener(this::shouldScrollTo);
        node.focusedElementProperty().addListener(this::shouldChangeFocus);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public N getNode() {
        return this.node;
    }

    public int method_25322() {
        return this.node.getWidth() - this.node.getPadding().getHorizontal() - 6;
    }

    protected int method_25329() {
        return this.node.getRight() - 6;
    }

    public int method_25342() {
        return this.node.getLeft() + this.node.getPadding().getLeft();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25308(mouseX, mouseY) == null && (mouseX < (double)this.method_25329() || mouseX > (double)this.node.getRight())) {
            this.method_25395(null);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25395(@Nullable class_364 listener) {
        super.method_25395(listener);
        if (listener == null) {
            this.node.setFocusedElement(null);
        } else {
            this.node.setFocusedElement(((NodeEntry)listener).item);
        }
    }

    @Override
    public boolean preRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        boolean res = false;
        if (this.shouldRefreshSize) {
            this.refreshSize();
            res = true;
        }
        if (this.shouldRefreshList) {
            this.refreshList();
            res = true;
        }
        if (this.shouldScrollTo) {
            this.scrollTo();
            res = true;
        }
        if (this.shouldChangeFocus) {
            this.changeFocus();
            res = true;
        }
        return res;
    }

    @Override
    public void postRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        for (NodeEntry entry : this.method_25396()) {
            entry.getNode().postRender(guiGraphics, mouseX, mouseY, delta);
        }
    }

    protected void shouldRefreshSize() {
        this.shouldRefreshSize = true;
    }

    protected void shouldRefreshList() {
        this.shouldRefreshList = true;
    }

    protected void shouldScrollTo() {
        this.shouldScrollTo = true;
    }

    protected void shouldChangeFocus() {
        this.shouldChangeFocus = true;
    }

    protected void refreshSize() {
        this.field_22758 = this.node.getWidth();
        this.field_22759 = this.node.getHeight();
        this.method_46421(this.node.getX());
        this.method_46419(this.node.getY());
        this.shouldRefreshSize = false;
    }

    public int method_55442() {
        return this.node.getRight();
    }

    public int method_55443() {
        return this.node.getBottom();
    }

    protected void refreshList() {
        this.method_25339();
        this.createList();
        this.method_25307(this.method_25341());
        this.shouldRefreshList = false;
    }

    protected abstract void createList();

    protected void scrollTo() {
        for (NodeEntry e : this.method_25396()) {
            if (e.getItem() != this.node.getScrollTo()) continue;
            this.method_25324(e);
            break;
        }
        this.shouldScrollTo = false;
    }

    protected void changeFocus() {
        for (NodeEntry e : this.method_25396()) {
            if (e.getItem() != this.node.getFocusedElement()) continue;
            super.method_25395((class_364)e);
            break;
        }
        this.shouldChangeFocus = false;
    }

    @Override
    public void doTick() {
        for (NodeEntry child : this.method_25396()) {
            child.getNode().doTick();
        }
    }

    @Override
    public void mouseClicked(MouseButtonEvent event) {
        VanillaWidgetSkinDelegate.super.mouseClicked(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_CLICKED, event);
    }

    @Override
    public void mouseReleased(MouseButtonEvent event) {
        VanillaWidgetSkinDelegate.super.mouseReleased(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_RELEASED, event);
    }

    @Override
    public void mouseDragged(MouseDragEvent event) {
        VanillaWidgetSkinDelegate.super.mouseDragged(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_DRAGGED, event);
    }

    @Override
    public void mouseScrolled(MouseScrollEvent event) {
        VanillaWidgetSkinDelegate.super.mouseScrolled(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_SCOLLED, event);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        VanillaWidgetSkinDelegate.super.mouseMoved(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_MOVED, event);
    }

    protected <EE extends MouseEvent> void handleMouseEvent(ScreenEventType<EE> target, EE event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        if (mouseX < (double)this.node.getLeft() || mouseX > (double)this.node.getRight() || mouseY < (double)this.node.getTop() || mouseY > (double)this.node.getBottom()) {
            return;
        }
        int index = 0;
        for (NodeEntry child : this.method_25396()) {
            Node childNode = child.getNode();
            if (childNode == null) {
                ++index;
                continue;
            }
            double childTop = childNode.getTop();
            double childBottom = childNode.getBottom();
            if (childTop < (double)this.node.getTop()) {
                childTop = this.node.getTop();
            }
            if (childBottom > (double)this.node.getBottom()) {
                childBottom = this.node.getBottom();
            }
            if (mouseY < childTop || mouseY >= childBottom) {
                ++index;
                continue;
            }
            child.getNode().handleEvent(target, event);
            if (event.getTarget() != null) {
                return;
            }
            ++index;
        }
    }

    protected static abstract class NodeEntry<N extends ListNode<E>, E, T extends NodeEntry<N, E, T>>
    extends class_350.class_351<T> {
        private final AbstractVanillaListNodeSkinDelegate<N, E, T> list;
        private final E item;
        private Node node;

        public NodeEntry(AbstractVanillaListNodeSkinDelegate<N, E, T> list, E item) {
            this(list, item, null);
        }

        public NodeEntry(AbstractVanillaListNodeSkinDelegate<N, E, T> list, E item, Node node) {
            this.list = list;
            this.item = item;
            this.node = node;
        }

        public AbstractVanillaListNodeSkinDelegate<N, E, T> getList() {
            return this.list;
        }

        public E getItem() {
            return this.item;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        protected void renderBackground(class_332 guiGraphics, int x, int y, int entryWidth, int entryHeight) {
            if (this.getList().method_25336() == this) {
                RenderHelper.fillRectangle(guiGraphics, x - 2, y - 2, x + entryWidth + 3, y + entryHeight + 2, Color.fromRGBA(255, 255, 255, 79));
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.list.node.isChildrenFocusable();
        }
    }
}

