/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ListSelectionFilter;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.EnchantmentListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.EntityListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableTagListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SortedEnchantmentListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SoundEventListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SpriteListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.TagListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.TrimMaterialSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.TrimPatternSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ColoredItemHelper;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.loot.LootTableIndex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9274;
import net.minecraft.class_9636;

public final class ClientCache {
    private static List<String> itemSuggestions;
    private static List<ItemListSelectionElementModel> itemSelectionItems;
    private static List<String> blockSuggestions;
    private static List<ItemListSelectionElementModel> blockSelectionItems;
    private static List<TagListSelectionElementModel> blockTagSelectionItems;
    private static List<String> enchantmentSuggestions;
    private static List<EnchantmentListSelectionElementModel> enchantmentSelectionItems;
    private static List<String> attributeSuggestions;
    private static List<ListSelectionElementModel> attributeSelectionItems;
    private static List<String> potionSuggestions;
    private static List<ItemListSelectionElementModel> potionSelectionItems;
    private static List<String> effectSuggestions;
    private static List<SpriteListSelectionElementModel> effectSelectionItems;
    private static List<String> entitySuggestions;
    private static List<EntityListSelectionElementModel> entitySelectionItems;
    private static List<String> villagerProfessionSuggestions;
    private static List<ListSelectionElementModel> villagerProfessionSelectionItems;
    private static List<String> villagerTypeSuggestions;
    private static List<ListSelectionElementModel> villagerTypeSelectionItems;
    private static List<String> trimPatternSuggestions;
    private static List<TrimPatternSelectionElementModel> trimPatternSelectionItems;
    private static List<String> trimMaterialSuggestions;
    private static List<TrimMaterialSelectionElementModel> trimMaterialSelectionItems;
    private static List<String> instrumentSuggestions;
    private static List<ListSelectionElementModel> instrumentSelectionItems;
    private static List<String> soundEventSuggestions;
    private static List<SoundEventListSelectionElementModel> soundEventSelectionItems;
    private static List<ListSelectionFilter> soundEventFilters;
    private static List<String> blockEntityTypeSuggestions;
    private static List<String> lootTableSuggestions;

    public static void invalidate() {
        itemSuggestions = null;
        itemSelectionItems = null;
        blockSuggestions = null;
        blockSelectionItems = null;
        blockTagSelectionItems = null;
        enchantmentSuggestions = null;
        enchantmentSelectionItems = null;
        attributeSuggestions = null;
        attributeSelectionItems = null;
        potionSuggestions = null;
        potionSelectionItems = null;
        effectSuggestions = null;
        effectSelectionItems = null;
        entitySuggestions = null;
        entitySelectionItems = null;
        villagerProfessionSuggestions = null;
        villagerProfessionSelectionItems = null;
        villagerTypeSuggestions = null;
        villagerTypeSelectionItems = null;
        trimPatternSuggestions = null;
        trimPatternSelectionItems = null;
        trimMaterialSuggestions = null;
        trimMaterialSelectionItems = null;
        instrumentSuggestions = null;
        instrumentSelectionItems = null;
        soundEventSuggestions = null;
        soundEventSelectionItems = null;
        soundEventFilters = null;
        blockEntityTypeSuggestions = null;
        lootTableSuggestions = null;
    }

    public static List<String> getItemSuggestions() {
        return itemSuggestions == null ? (itemSuggestions = ClientCache.buildSuggestions(class_7923.field_41178)) : itemSuggestions;
    }

    public static List<ItemListSelectionElementModel> getItemSelectionItems() {
        return itemSelectionItems == null ? (itemSelectionItems = ClientCache.buildItemSelectionItems()) : itemSelectionItems;
    }

    public static List<String> getBlockSuggestions() {
        return blockSuggestions == null ? (blockSuggestions = ClientCache.buildSuggestions(class_7923.field_41175)) : blockSuggestions;
    }

    public static List<ItemListSelectionElementModel> getBlockSelectionItems() {
        return blockSelectionItems == null ? (blockSelectionItems = ClientCache.buildBlockSelectionItems()) : blockSelectionItems;
    }

    public static List<TagListSelectionElementModel> getBlockTagSelectionItems() {
        return blockTagSelectionItems == null ? (blockTagSelectionItems = ClientCache.buildBlockTagSelectionItems()) : blockTagSelectionItems;
    }

    public static List<String> getBlockEntityTypeSuggestions() {
        return blockEntityTypeSuggestions == null ? (blockEntityTypeSuggestions = ClientCache.buildSuggestions(class_7923.field_41181)) : blockEntityTypeSuggestions;
    }

    public static List<String> getEnchantmentSuggestions() {
        if (enchantmentSuggestions == null) {
            enchantmentSuggestions = ClientCache.registryAccess().method_46759(class_7924.field_41265).map(ClientCache::buildSuggestions).orElseGet(List::of);
        }
        return enchantmentSuggestions;
    }

    public static List<SortedEnchantmentListSelectionElementModel> getSortedEnchantmentSelectionItems(class_1799 target) {
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().map(item -> {
            boolean curse = item.getEnchantment().method_40220(class_9636.field_51551);
            boolean canApply = ClientCache.enchantmentCanApply(item.getEnchantment(), target);
            return new SortedEnchantmentListSelectionElementModel((EnchantmentListSelectionElementModel)item, curse, canApply);
        }).sorted(Comparator.comparing(m -> m.canApply() ? 0 : 1).thenComparing(m -> m.isCurse() ? 1 : 0).thenComparing(m -> m.getName().toLowerCase(Locale.ROOT))).toList();
    }

    public static Optional<EnchantmentListSelectionElementModel> findEnchantmentSelectionItem(class_2960 id) {
        if (id == null) {
            return Optional.empty();
        }
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    private static boolean enchantmentCanApply(class_6880<class_1887> enchantment, class_1799 target) {
        if (target == null || target.method_7960()) {
            return false;
        }
        if (target.method_31574(class_1802.field_8598) || target.method_31574(class_1802.field_8529)) {
            return true;
        }
        class_1887 value = (class_1887)enchantment.comp_349();
        if (value.method_8192(target)) {
            return true;
        }
        class_1792 item = target.method_7909();
        class_1887.class_9427 definition = value.comp_2687();
        Optional registry = ClientCache.registryAccess().method_46759(class_7924.field_41197);
        if (definition.comp_2507().map(set -> ClientCache.holderSetContainsItem((class_6885<class_1792>)set, item, registry)).orElse(false).booleanValue()) {
            return true;
        }
        return ClientCache.holderSetContainsItem((class_6885<class_1792>)definition.comp_2506(), item, registry);
    }

    private static boolean holderSetContainsItem(class_6885<class_1792> holders, class_1792 item, Optional<class_7225.class_7226<class_1792>> registry) {
        if (holders == null) {
            return false;
        }
        try {
            if (holders.method_40241(class_7923.field_41178.method_47983((Object)item))) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        class_5321 key = class_7923.field_41178.method_29113((Object)item).orElse(null);
        if (key == null && registry.isPresent()) {
            key = registry.get().method_42017().filter(reference -> {
                try {
                    return reference.comp_349() == item;
                }
                catch (IllegalStateException ignored) {
                    return false;
                }
            }).map(class_6880.class_6883::method_40237).findFirst().orElse(null);
        }
        for (class_6880 holder : holders) {
            if (key != null && holder.method_40225(key)) {
                return true;
            }
            try {
                if (holder.comp_349() != item) continue;
                return true;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return false;
    }

    public static List<String> getAttributeSuggestions() {
        return attributeSuggestions == null ? (attributeSuggestions = ClientCache.buildSuggestions(class_7923.field_41190)) : attributeSuggestions;
    }

    public static List<ListSelectionElementModel> getAttributeSelectionItems() {
        return attributeSelectionItems == null ? (attributeSelectionItems = ClientCache.buildAttributeSelectionItems()) : attributeSelectionItems;
    }

    public static Optional<ListSelectionElementModel> findAttributeSelectionItem(class_2960 id) {
        if (id == null) {
            return Optional.empty();
        }
        if (attributeSelectionItems == null) {
            attributeSelectionItems = ClientCache.buildAttributeSelectionItems();
        }
        return attributeSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    public static List<String> getPotionSuggestions() {
        return potionSuggestions == null ? (potionSuggestions = ClientCache.buildSuggestions(class_7923.field_41179)) : potionSuggestions;
    }

    public static List<ItemListSelectionElementModel> getPotionSelectionItems() {
        return potionSelectionItems == null ? (potionSelectionItems = ClientCache.buildPotionSelectionItems()) : potionSelectionItems;
    }

    public static List<String> getEffectSuggestions() {
        return effectSuggestions == null ? (effectSuggestions = ClientCache.buildSuggestions(class_7923.field_41174)) : effectSuggestions;
    }

    public static List<SpriteListSelectionElementModel> getEffectSelectionItems() {
        return effectSelectionItems == null ? (effectSelectionItems = ClientCache.buildEffectSelectionItems()) : effectSelectionItems;
    }

    public static List<String> getEntitySuggestions() {
        return entitySuggestions == null ? (entitySuggestions = ClientCache.buildSuggestions(class_7923.field_41177)) : entitySuggestions;
    }

    public static List<EntityListSelectionElementModel> getEntitySelectionItems() {
        return entitySelectionItems == null ? (entitySelectionItems = ClientCache.buildEntitySelectionItems()) : entitySelectionItems;
    }

    public static List<String> getVillagerProfessionSuggestions() {
        return villagerProfessionSuggestions == null ? (villagerProfessionSuggestions = ClientCache.buildSuggestions(class_7923.field_41195)) : villagerProfessionSuggestions;
    }

    public static List<ListSelectionElementModel> getVillagerProfessionSelectionItems() {
        return villagerProfessionSelectionItems == null ? (villagerProfessionSelectionItems = ClientCache.buildVillagerProfessionSelectionItems()) : villagerProfessionSelectionItems;
    }

    public static List<String> getVillagerTypeSuggestions() {
        return villagerTypeSuggestions == null ? (villagerTypeSuggestions = ClientCache.buildSuggestions(class_7923.field_41194)) : villagerTypeSuggestions;
    }

    public static List<ListSelectionElementModel> getVillagerTypeSelectionItems() {
        return villagerTypeSelectionItems == null ? (villagerTypeSelectionItems = ClientCache.buildVillagerTypeSelectionItems()) : villagerTypeSelectionItems;
    }

    public static List<String> getTrimPatternSuggestions() {
        if (trimPatternSuggestions == null) {
            trimPatternSuggestions = ClientCache.getTrimPatternSelectionItems().stream().map(element -> element.getId().toString()).toList();
        }
        return trimPatternSuggestions;
    }

    public static List<TrimPatternSelectionElementModel> getTrimPatternSelectionItems() {
        if (trimPatternSelectionItems == null) {
            trimPatternSelectionItems = ClientCache.registryAccess().method_46759(class_7924.field_42082).map(ClientCache::buildTrimPatternSelectionItems).orElseGet(List::of);
        }
        return trimPatternSelectionItems;
    }

    public static List<String> getTrimMaterialSuggestions() {
        if (trimMaterialSuggestions == null) {
            trimMaterialSuggestions = ClientCache.getTrimMaterialSelectionItems().stream().map(element -> element.getId().toString()).toList();
        }
        return trimMaterialSuggestions;
    }

    public static List<TrimMaterialSelectionElementModel> getTrimMaterialSelectionItems() {
        if (trimMaterialSelectionItems == null) {
            trimMaterialSelectionItems = ClientCache.registryAccess().method_46759(class_7924.field_42083).map(ClientCache::buildTrimMaterialSelectionItems).orElseGet(List::of);
        }
        return trimMaterialSelectionItems;
    }

    public static List<String> getInstrumentSuggestions() {
        if (instrumentSuggestions == null) {
            instrumentSuggestions = ClientCache.getInstrumentSelectionItems().stream().map(element -> element.getId().toString()).toList();
        }
        return instrumentSuggestions;
    }

    public static List<ListSelectionElementModel> getInstrumentSelectionItems() {
        if (instrumentSelectionItems == null) {
            instrumentSelectionItems = ClientCache.registryAccess().method_46759(class_7924.field_41275).map(ClientCache::buildInstrumentSelectionItems).orElseGet(List::of);
        }
        return instrumentSelectionItems;
    }

    public static List<String> getSoundEventSuggestions() {
        return soundEventSuggestions == null ? (soundEventSuggestions = ClientCache.buildSuggestions(class_7923.field_41172)) : soundEventSuggestions;
    }

    public static List<SoundEventListSelectionElementModel> getSoundEventSelectionItems() {
        if (soundEventSelectionItems == null) {
            soundEventSelectionItems = ClientCache.buildSoundEventSelectionItems();
        }
        return soundEventSelectionItems;
    }

    public static List<ListSelectionFilter> getSoundEventFilters() {
        if (soundEventFilters == null) {
            soundEventFilters = ClientCache.buildSoundEventFilters();
        }
        return soundEventFilters;
    }

    public static List<String> getLootTableSuggestions() {
        if (lootTableSuggestions == null) {
            lootTableSuggestions = ClientCache.buildLootTableSuggestions();
        }
        return lootTableSuggestions;
    }

    public static Optional<SpriteListSelectionElementModel> findEffectSelectionItem(class_2960 id) {
        if (id == null) {
            return Optional.empty();
        }
        if (effectSelectionItems == null) {
            effectSelectionItems = ClientCache.buildEffectSelectionItems();
        }
        return effectSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    private static List<String> buildSuggestions(class_2378<?> registry) {
        ArrayList<String> suggestions = new ArrayList<String>();
        registry.method_29722().stream().map(e -> ((class_5321)e.getKey()).method_29177().toString()).forEach(id -> {
            suggestions.add((String)id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<String> buildSuggestions(class_7225.class_7226<?> lookup) {
        ArrayList<String> suggestions = new ArrayList<String>();
        lookup.method_42017().forEach(holder -> {
            String id = holder.method_40237().method_29177().toString();
            suggestions.add(id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<String> buildLootTableSuggestions() {
        List<class_2960> ids = LootTableIndex.getAll();
        if (ids.isEmpty()) {
            return List.of();
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (class_2960 id : ids) {
            String full = id.toString();
            values.add(full);
            if (!full.startsWith("minecraft:")) continue;
            values.add(full.substring(10));
        }
        return List.copyOf(values);
    }

    private static List<ItemListSelectionElementModel> buildItemSelectionItems() {
        return class_7923.field_41178.method_29722().stream().map(e -> new ItemListSelectionElementModel(((class_1792)e.getValue()).method_7876(), ((class_5321)e.getKey()).method_29177(), () -> new class_1799((class_1935)e.getValue()))).sorted().toList();
    }

    private static List<TagListSelectionElementModel> buildBlockTagSelectionItems() {
        return ClientCache.registryAccess().method_46759(class_7924.field_41254).map(lookup -> lookup.method_42020().map(named -> new SelectableTagListSelectionElementModel(named.method_40251().comp_327())).sorted().toList()).orElseGet(List::of);
    }

    private static List<ItemListSelectionElementModel> buildBlockSelectionItems() {
        return class_7923.field_41175.method_29722().stream().map(e -> new SelectableItemListSelectionElementModel(((class_2248)e.getValue()).method_9539(), ((class_5321)e.getKey()).method_29177(), () -> new class_1799((class_1935)e.getValue()))).sorted().toList();
    }

    private static List<EntityListSelectionElementModel> buildEntitySelectionItems() {
        return class_7923.field_41177.method_29722().stream().map(e -> new EntityListSelectionElementModel((class_1299)e.getValue(), ((class_5321)e.getKey()).method_29177())).sorted().toList();
    }

    private static List<ListSelectionElementModel> buildVillagerProfessionSelectionItems() {
        return class_7923.field_41195.method_29722().stream().map(e -> new ListSelectionElementModel(ClientCache.villagerProfessionTranslation(((class_5321)e.getKey()).method_29177()), ((class_5321)e.getKey()).method_29177())).sorted().toList();
    }

    private static List<ListSelectionElementModel> buildVillagerTypeSelectionItems() {
        return class_7923.field_41194.method_29722().stream().map(e -> new ListSelectionElementModel(ClientCache.villagerTypeTranslation(((class_5321)e.getKey()).method_29177()), ((class_5321)e.getKey()).method_29177())).sorted().toList();
    }

    private static String villagerProfessionTranslation(class_2960 id) {
        return "villager.profession." + id.method_12832();
    }

    private static String villagerTypeTranslation(class_2960 id) {
        return "entity.minecraft.villager." + id.method_12832();
    }

    private static List<EnchantmentListSelectionElementModel> buildEnchantmentSelectionItems() {
        return ClientCache.registryAccess().method_46759(class_7924.field_41265).map(lookup -> lookup.method_42017().map(ref -> {
            class_1792 iconItem = ClientCache.getEnchantmentTypeItem((class_6880<class_1887>)ref);
            class_1799 icon = new class_1799((class_1935)iconItem);
            class_2561 categoryLabel = ClientCache.buildEnchantmentCategoryLabel((class_6880<class_1887>)ref, icon);
            return new EnchantmentListSelectionElementModel(((class_1887)ref.comp_349()).comp_2686().getString(), ref.method_40237().method_29177(), (class_6880<class_1887>)ref, () -> new class_1799((class_1935)iconItem), categoryLabel);
        }).sorted().toList()).orElseGet(List::of);
    }

    private static class_2561 buildEnchantmentCategoryLabel(class_6880<class_1887> enchantment, class_1799 icon) {
        List<class_2561> labels = ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().map(ClientCache::describeItemSet).orElseGet(List::of);
        if (labels.isEmpty()) {
            labels = ClientCache.describeItemSet((class_6885<class_1792>)((class_1887)enchantment.comp_349()).comp_2687().comp_2506());
        }
        if (!labels.isEmpty()) {
            return ClientCache.joinComponents(labels);
        }
        List<class_2561> slotLabels = ClientCache.describeSlotGroups(((class_1887)enchantment.comp_349()).comp_2687().comp_2513());
        if (!slotLabels.isEmpty()) {
            return ClientCache.joinComponents(slotLabels);
        }
        return icon.method_7964().method_27661();
    }

    private static class_1792 getEnchantmentTypeItem(class_6880<class_1887> enchantment) {
        return ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().flatMap(ClientCache::pickRepresentativeItem).or(() -> ClientCache.pickRepresentativeItem((class_6885<class_1792>)((class_1887)enchantment.comp_349()).comp_2687().comp_2506())).or(() -> ClientCache.pickItemFromSlots(((class_1887)enchantment.comp_349()).comp_2687().comp_2513())).orElse(class_1802.field_8598);
    }

    private static List<class_2561> describeItemSet(class_6885<class_1792> holders) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        LinkedHashSet seen = new LinkedHashSet();
        holders.method_40239().map(class_6880::comp_349).filter(item -> item != class_1802.field_8162).forEach(item -> {
            if (seen.add(item.method_7876())) {
                result.add((class_2561)new class_1799((class_1935)item).method_7964().method_27661());
            }
        });
        return ClientCache.limitComponentList(result);
    }

    private static List<class_2561> describeSlotGroups(List<class_9274> slots) {
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        for (class_9274 slot : slots) {
            String raw = slot.name().toLowerCase(Locale.ROOT).replace('_', ' ');
            if (!seen.add(raw)) continue;
            result.add((class_2561)class_2561.method_43470((String)ClientCache.capitalizeWords(raw)));
        }
        return ClientCache.limitComponentList(result);
    }

    private static List<class_2561> limitComponentList(List<class_2561> components) {
        int max = 3;
        if (components.size() <= max) {
            return components;
        }
        ArrayList<class_2561> limited = new ArrayList<class_2561>(components.subList(0, max));
        limited.add((class_2561)class_2561.method_43470((String)"\u2026"));
        return limited;
    }

    private static class_2561 joinComponents(List<class_2561> components) {
        class_5250 result = class_2561.method_43473();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                result.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            result.method_10852((class_2561)components.get(i).method_27661());
        }
        return result;
    }

    private static String capitalizeWords(String input) {
        if (input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder(input.length());
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                builder.append(c);
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static Optional<class_1792> pickRepresentativeItem(class_6885<class_1792> holders) {
        return holders.method_40239().map(class_6880::comp_349).filter(item -> item != class_1802.field_8162).min(Comparator.comparing(item -> class_7923.field_41178.method_10221(item).toString()));
    }

    private static Optional<class_1792> pickItemFromSlots(List<class_9274> slots) {
        if (slots.contains(class_9274.field_49224) || slots.contains(class_9274.field_50127)) {
            return Optional.of(class_1802.field_8523);
        }
        if (slots.contains(class_9274.field_49223)) {
            return Optional.of(class_1802.field_8805);
        }
        if (slots.contains(class_9274.field_49222)) {
            return Optional.of(class_1802.field_8058);
        }
        if (slots.contains(class_9274.field_49221)) {
            return Optional.of(class_1802.field_8348);
        }
        if (slots.contains(class_9274.field_49220)) {
            return Optional.of(class_1802.field_8285);
        }
        if (slots.contains(class_9274.field_49217) || slots.contains(class_9274.field_49219)) {
            return Optional.of(class_1802.field_8802);
        }
        if (slots.contains(class_9274.field_49218)) {
            return Optional.of(class_1802.field_8255);
        }
        return Optional.empty();
    }

    private static List<ListSelectionElementModel> buildAttributeSelectionItems() {
        return class_7923.field_41190.method_29722().stream().map(e -> new ListSelectionElementModel(((class_1320)e.getValue()).method_26830(), ((class_5321)e.getKey()).method_29177())).sorted().toList();
    }

    private static List<ItemListSelectionElementModel> buildPotionSelectionItems() {
        return class_7923.field_41179.method_29722().stream().map(e -> class_7923.field_41179.method_40264((class_5321)e.getKey()).map(holder -> new ItemListSelectionElementModel(class_1842.method_8051(Optional.of(holder), (String)(class_1802.field_8574.method_7876() + ".effect.")), ((class_5321)e.getKey()).method_29177(), () -> ColoredItemHelper.createColoredPotionItem(((class_5321)e.getKey()).method_29177(), Integer.MIN_VALUE))).orElse(null)).filter(Objects::nonNull).sorted().toList();
    }

    private static List<SpriteListSelectionElementModel> buildEffectSelectionItems() {
        return class_7923.field_41174.method_29722().stream().map(e -> class_7923.field_41174.method_40264((class_5321)e.getKey()).map(holder -> new SpriteListSelectionElementModel(((class_1291)holder.comp_349()).method_5567(), ((class_5321)e.getKey()).method_29177(), () -> class_310.method_1551().method_18505().method_18663((class_6880)holder))).orElse(null)).filter(Objects::nonNull).sorted().toList();
    }

    private static List<TrimPatternSelectionElementModel> buildTrimPatternSelectionItems(class_7225.class_7226<class_8056> lookup) {
        return lookup.method_42017().map(holder -> {
            class_6880 itemHolder = ((class_8056)holder.comp_349()).comp_1214();
            return new TrimPatternSelectionElementModel(((class_8056)holder.comp_349()).comp_1215(), holder.method_40237().method_29177(), ClientCache.iconFromHolder((class_6880<class_1792>)itemHolder));
        }).sorted().toList();
    }

    private static List<TrimMaterialSelectionElementModel> buildTrimMaterialSelectionItems(class_7225.class_7226<class_8054> lookup) {
        return lookup.method_42017().map(holder -> new TrimMaterialSelectionElementModel(((class_8054)holder.comp_349()).comp_1212(), holder.method_40237().method_29177(), ClientCache.iconFromHolder((class_6880<class_1792>)((class_8054)holder.comp_349()).comp_1209()))).sorted().toList();
    }

    private static List<ListSelectionElementModel> buildInstrumentSelectionItems(class_7225.class_7226<class_7444> lookup) {
        return lookup.method_42017().map(holder -> new ListSelectionElementModel(holder.method_40237().method_29177().toString(), holder.method_40237().method_29177())).sorted().toList();
    }

    private static List<SoundEventListSelectionElementModel> buildSoundEventSelectionItems() {
        return class_7923.field_41172.method_29722().stream().map(entry -> new SoundEventListSelectionElementModel(((class_5321)entry.getKey()).method_29177(), (class_3414)entry.getValue())).sorted().toList();
    }

    private static List<ListSelectionFilter> buildSoundEventFilters() {
        List<SoundEventListSelectionElementModel> items = ClientCache.getSoundEventSelectionItems();
        if (items.isEmpty()) {
            return List.of(new ListSelectionFilter("all", ModTexts.SOUND_FILTER_ALL, null));
        }
        ArrayList<ListSelectionFilter> filters = new ArrayList<ListSelectionFilter>();
        filters.add(new ListSelectionFilter("all", ModTexts.SOUND_FILTER_ALL, null));
        items.stream().map(SoundEventListSelectionElementModel::getNamespace).distinct().sorted().forEach(namespace -> filters.add(new ListSelectionFilter("namespace:" + namespace, ModTexts.soundFilterNamespace(namespace), element -> {
            SoundEventListSelectionElementModel sound;
            return element instanceof SoundEventListSelectionElementModel && (sound = (SoundEventListSelectionElementModel)element).getNamespace().equals(namespace);
        })));
        return List.copyOf(filters);
    }

    private static Supplier<class_1799> iconFromHolder(class_6880<class_1792> holder) {
        return () -> {
            try {
                return ((class_1792)holder.comp_349()).method_7854();
            }
            catch (IllegalStateException ignored) {
                return class_1799.field_8037;
            }
        };
    }

    private static class_7225.class_7874 registryAccess() {
        return ClientUtil.registryAccess();
    }
}

