/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.base.NodeFactoryImpl;
import com.github.franckyi.guapi.base.ScreenHandlerImpl;
import com.github.franckyi.guapi.base.theme.vanilla.VanillaTheme;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.ModGuapiExceptionHandler;
import com.github.rinorsi.cadeditor.client.UpdateLogRegistry;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.debug.DebugLog;
import com.github.rinorsi.cadeditor.client.theme.MonochromeTheme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientInit {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        LOGGER.info("\u521d\u59cb\u5316 CAD Editor\uff08\u5ba2\u6237\u7aef\uff09");
        Guapi.registerTheme("vanilla", VanillaTheme.INSTANCE);
        Guapi.registerTheme("monochrome", MonochromeTheme.INSTANCE);
        Guapi.setNodeFactory(NodeFactoryImpl.INSTANCE);
        Guapi.setScreenHandler(ScreenHandlerImpl.INSTANCE);
        Guapi.setDefaultLogger(LogManager.getLogger((String)"CAD Editor"));
        Guapi.setExceptionHandler(ModGuapiExceptionHandler.INSTANCE);
    }

    public static void setup() {
        LOGGER.info("\u8bbe\u7f6e CAD Editor\uff08\u5ba2\u6237\u7aef\uff09");
        ClientConfiguration.load();
        ClientInit.syncGuapiConfig();
        UpdateLogRegistry.load();
        Vault.load();
    }

    public static void syncGuapiConfig() {
        Guapi.setDebugMode(ClientConfiguration.INSTANCE.getGuapiDebugMode());
        DebugLog.modeChanged(ClientConfiguration.INSTANCE.getGuapiDebugMode());
        Guapi.setTheme(ClientConfiguration.INSTANCE.getGuapiTheme());
    }
}

