/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public abstract class EditorContext<T extends EditorContext<T>> {
    private class_2487 tag;
    protected class_2561 errorTooltip;
    protected boolean canSaveToVault;
    private boolean isSaveToVault = false;
    private boolean isCopyCommand = false;
    private final Consumer<T> action;

    public EditorContext(class_2487 tag, class_2561 errorTooltip, boolean canSaveToVault, Consumer<T> action) {
        this.tag = tag;
        this.errorTooltip = errorTooltip;
        this.canSaveToVault = canSaveToVault;
        this.action = action;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(class_2487 tag) {
        this.tag = tag;
    }

    public class_2561 getErrorTooltip() {
        return this.errorTooltip;
    }

    public boolean hasPermission() {
        return this.errorTooltip == null;
    }

    public void update() {
        if (this.isSaveToVault() && this.canSaveToVault()) {
            this.saveToVault();
        }
        if (this.isCopyCommand()) {
            class_310.method_1551().field_1774.method_1455(this.getCommand());
            ClientUtil.showMessage((class_2561)this.getCopySuccessMessage());
        }
        if (this.hasPermission() && this.action != null) {
            this.action.accept(this);
        }
    }

    public boolean canSaveToVault() {
        return this.canSaveToVault;
    }

    public boolean isSaveToVault() {
        return this.isSaveToVault;
    }

    public void setSaveToVault(boolean isSaveToVault) {
        this.isSaveToVault = isSaveToVault;
    }

    public boolean isCopyCommand() {
        return this.isCopyCommand;
    }

    public void setCopyCommand(boolean copyCommand) {
        this.isCopyCommand = copyCommand;
    }

    public void saveToVault() {
    }

    public abstract class_5250 getTargetName();

    public class_5250 getCommandTooltip() {
        return ModTexts.copyCommand(this.getCommandName());
    }

    public abstract String getCommandName();

    protected abstract String getCommand();

    protected class_5250 getCopySuccessMessage() {
        return ModTexts.Messages.successCopyClipboard(this.getCommandName());
    }

    public List<String> getStringSuggestions(List<String> path) {
        if (path == null || path.isEmpty()) {
            return List.of();
        }
        String key = EditorContext.lastKey(path);
        if (key == null) {
            return List.of();
        }
        if (EditorContext.equalsAnyIgnoreCase(key, "LootTable", "LootTableId", "loot_table", "loot_table_id")) {
            return ClientCache.getLootTableSuggestions();
        }
        return List.of();
    }

    protected static String lastKey(List<String> path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return path.get(path.size() - 1);
    }

    protected static String previousNamedKey(List<String> path, int depth) {
        if (path == null || path.isEmpty() || depth <= 0) {
            return null;
        }
        int remaining = depth;
        for (int i = path.size() - 2; i >= 0; --i) {
            String candidate = path.get(i);
            if (EditorContext.isIndexElement(candidate) || --remaining != 0) continue;
            return candidate;
        }
        return null;
    }

    protected static boolean pathContains(List<String> path, String key) {
        if (path == null || key == null) {
            return false;
        }
        for (String element : path) {
            if (EditorContext.isIndexElement(element) || !key.equals(element)) continue;
            return true;
        }
        return false;
    }

    protected static boolean equalsAnyIgnoreCase(String value, String ... candidates) {
        if (value == null) {
            return false;
        }
        for (String candidate : candidates) {
            if (candidate == null || !value.equalsIgnoreCase(candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIndexElement(String value) {
        return value != null && value.startsWith("[") && value.endsWith("]");
    }
}

