/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class EntityEditorContext
extends EditorContext<EntityEditorContext> {
    private final class_1297 entity;

    public EntityEditorContext(class_2487 tag, class_2561 errorTooltip, boolean canSaveToVault, Consumer<EntityEditorContext> action) {
        super(tag, errorTooltip, canSaveToVault, action);
        this.entity = class_1299.method_5892((class_2487)tag, (class_1937)class_310.method_1551().field_1687).orElse(null);
        if (this.entity == null) {
            this.canSaveToVault = false;
        }
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    @Override
    public void saveToVault() {
        Vault.getInstance().saveEntity(this.getTag());
        ClientUtil.showMessage((class_2561)ModTexts.Messages.successSavedVault(ModTexts.ENTITY));
    }

    @Override
    public class_5250 getTargetName() {
        return ModTexts.ENTITY;
    }

    @Override
    public String getCommandName() {
        return "/summon";
    }

    @Override
    protected String getCommand() {
        return String.format("/summon %s ~ ~ ~ %s", this.getTag().method_10558("id"), this.getSimpleTag());
    }

    @Override
    public List<String> getStringSuggestions(List<String> path) {
        List<String> suggestions = super.getStringSuggestions(path);
        if (!suggestions.isEmpty()) {
            return suggestions;
        }
        if (path == null || path.isEmpty()) {
            return List.of();
        }
        String key = EntityEditorContext.lastKey(path);
        if (key == null) {
            return List.of();
        }
        String parent = EntityEditorContext.previousNamedKey(path, 1);
        String grandParent = EntityEditorContext.previousNamedKey(path, 2);
        if ("id".equals(key)) {
            if (path.size() == 1) {
                return ClientCache.getEntitySuggestions();
            }
            if (EntityEditorContext.isItemSlot(parent, grandParent)) {
                return ClientCache.getItemSuggestions();
            }
            if (EntityEditorContext.isEffectContainer(parent, grandParent)) {
                return ClientCache.getEffectSuggestions();
            }
        }
        if (EntityEditorContext.equalsAnyIgnoreCase(key, "item", "Item")) {
            return ClientCache.getItemSuggestions();
        }
        if (EntityEditorContext.equalsAnyIgnoreCase(key, "potion")) {
            return ClientCache.getPotionSuggestions();
        }
        if (EntityEditorContext.equalsAnyIgnoreCase(key, "effect")) {
            return ClientCache.getEffectSuggestions();
        }
        return List.of();
    }

    private static boolean isItemSlot(String parent, String grandParent) {
        return EntityEditorContext.equalsAnyIgnoreCase(parent, "HandItems", "ArmorItems", "Items", "Inventory", "item", "Item", "SaddleItem") || EntityEditorContext.equalsAnyIgnoreCase(parent, "stack") && EntityEditorContext.equalsAnyIgnoreCase(grandParent, "minecraft:equipment");
    }

    private static boolean isEffectContainer(String parent, String grandParent) {
        return EntityEditorContext.equalsAnyIgnoreCase(parent, "ActiveEffects", "effects") || EntityEditorContext.equalsAnyIgnoreCase(grandParent, "ActiveEffects");
    }

    private class_2487 getSimpleTag() {
        class_2487 tag = this.getTag().method_10553();
        tag.method_10551("UUID");
        tag.method_10551("Pos");
        tag.method_10551("Rotation");
        return tag;
    }
}

