/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.debug;

import com.github.franckyi.guapi.api.util.DebugMode;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DebugLog {
    private static final Logger LOGGER = LogManager.getLogger((String)"CAD-Editor/Debug");
    private static final long UI_THROTTLE_MS = 500L;
    private static final Map<String, Long> UI_LAST_EMIT = new ConcurrentHashMap<String, Long>();
    private static volatile DebugMode lastAnnouncedMode = null;

    private DebugLog() {
    }

    public static void modeChanged(DebugMode mode) {
        DebugMode safeMode;
        DebugMode debugMode = safeMode = mode == null ? DebugMode.NONE : mode;
        if (safeMode != lastAnnouncedMode) {
            lastAnnouncedMode = safeMode;
            LOGGER.info("Debug mode switched to {}", (Object)safeMode);
        }
    }

    public static void info(String message) {
        DebugLog.info(() -> message);
    }

    public static void infoKey(String translationKey, Object ... args) {
        Object[] safeArgs = DebugLog.sanitizeArgs(args);
        DebugLog.info(() -> DebugLog.translate(translationKey, safeArgs));
    }

    public static void info(Supplier<String> messageSupplier) {
        if (DebugLog.currentMode() == DebugMode.INFO) {
            LOGGER.info("[Info] {}", (Object)messageSupplier.get());
        }
    }

    public static void ui(String key, Supplier<String> messageSupplier) {
        if (DebugLog.currentMode() != DebugMode.UI) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = UI_LAST_EMIT.put(key, now);
        if (last == null || now - last >= 500L) {
            LOGGER.info("[UI] {}", (Object)messageSupplier.get());
        }
    }

    private static DebugMode currentMode() {
        try {
            ClientConfiguration cfg = ClientConfiguration.INSTANCE;
            if (cfg == null) {
                return DebugMode.NONE;
            }
            DebugMode mode = cfg.getGuapiDebugMode();
            return mode == null ? DebugMode.NONE : mode;
        }
        catch (Throwable t) {
            return DebugMode.NONE;
        }
    }

    private static Object[] sanitizeArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] sanitized = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Object safe = DebugLog.sanitizeArg(arg);
            if (sanitized != null) {
                sanitized[i] = safe;
                continue;
            }
            if (safe == arg) continue;
            sanitized = new Object[args.length];
            System.arraycopy(args, 0, sanitized, 0, i);
            sanitized[i] = safe;
        }
        return sanitized == null ? args : sanitized;
    }

    private static Object sanitizeArg(Object arg) {
        if (arg == null || arg instanceof class_2561 || arg instanceof Number || arg instanceof Boolean || arg instanceof String) {
            return arg;
        }
        return String.valueOf(arg);
    }

    private static String translate(String translationKey, Object[] args) {
        try {
            if (class_1074.method_4663((String)translationKey)) {
                return class_1074.method_4662((String)translationKey, (Object[])args);
            }
        }
        catch (IllegalFormatException e) {
            LOGGER.warn("Failed to format translation {}", (Object)translationKey, (Object)e);
        }
        if (args == null || args.length == 0) {
            return translationKey;
        }
        return translationKey + " " + Arrays.toString(args);
    }
}

