/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.logic;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.BlockEditorContext;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.debug.DebugLog;
import com.github.rinorsi.cadeditor.client.logic.ClientEditorUpdateLogic;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.network.BlockEditorPacket;
import com.github.rinorsi.cadeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.MainHandItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class ClientEditorResponseLogic {
    public static void onMainHandItemEditorResponse(MainHandItemEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.mainhand", response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateMainHandItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onPlayerInventoryItemEditorResponse(PlayerInventoryItemEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.player_inventory", response.getSlot(), response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updatePlayerInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onBlockInventoryItemEditorResponse(BlockInventoryItemEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.block_inventory", response.getSlot(), response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateBlockInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onEntityInventoryItemEditorResponse(EntityInventoryItemEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.entity_inventory", response.getSlot(), response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateEntityInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onBlockEditorResponse(BlockEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.block", response.getBlockPos(), response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new BlockEditorContext(response.getBlockState(), response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.BLOCK), context -> ClientEditorUpdateLogic.updateBlock(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.BLOCK);
    }

    public static void onEntityEditorResponse(EntityEditorPacket.Response response) {
        DebugLog.infoKey("cadeditor.debug.response.entity", response.hasPermission());
        ModScreenHandler.openEditor(response.getEditorType(), new EntityEditorContext(response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ENTITY), true, context -> ClientEditorUpdateLogic.updateEntity(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ENTITY);
    }

    private static class_2561 getErrorTooltip(boolean hasPermission, class_5250 arg) {
        return hasPermission ? null : ModTexts.errorPermissionDenied(arg);
    }

    private static void notifyPermission(boolean hasPermission, class_5250 target) {
        if (!hasPermission) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.errorPermissionDenied(target));
            DebugLog.infoKey("cadeditor.debug.response.permission_denied", target.getString());
        }
    }
}

