/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.entity;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.node.ItemView;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeItemsEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.VaultItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.entity.VillagerTradeItemsEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class VillagerTradeItemsEntryController
extends EntryController<VillagerTradeItemsEntryModel, VillagerTradeItemsEntryView> {
    private final VillagerTradeEntryModel tradeModel;

    public VillagerTradeItemsEntryController(VillagerTradeItemsEntryModel model, VillagerTradeItemsEntryView view) {
        super(model, view);
        this.tradeModel = model.getTradeModel();
    }

    @Override
    public void bind() {
        super.bind();
        this.updateTitle(((VillagerTradeItemsEntryModel)this.model).getListIndex());
        ((VillagerTradeItemsEntryModel)this.model).listIndexProperty().addListener(this::updateTitle);
        this.bindItemControls(this.tradeModel.primaryItemProperty(), ((VillagerTradeItemsEntryView)this.view).getPrimaryItemView(), ((VillagerTradeItemsEntryView)this.view).getPrimaryItemNameLabel(), ((VillagerTradeItemsEntryView)this.view).getPrimaryChooseButton(), ((VillagerTradeItemsEntryView)this.view).getPrimaryEditButton(), ((VillagerTradeItemsEntryView)this.view).getPrimarySnbtButton(), ((VillagerTradeItemsEntryView)this.view).getPrimaryVaultButton(), ((VillagerTradeItemsEntryView)this.view).getPrimaryClearButton());
        this.bindItemControls(this.tradeModel.secondaryItemProperty(), ((VillagerTradeItemsEntryView)this.view).getSecondaryItemView(), ((VillagerTradeItemsEntryView)this.view).getSecondaryItemNameLabel(), ((VillagerTradeItemsEntryView)this.view).getSecondaryChooseButton(), ((VillagerTradeItemsEntryView)this.view).getSecondaryEditButton(), ((VillagerTradeItemsEntryView)this.view).getSecondarySnbtButton(), ((VillagerTradeItemsEntryView)this.view).getSecondaryVaultButton(), ((VillagerTradeItemsEntryView)this.view).getSecondaryClearButton());
        this.bindItemControls(this.tradeModel.resultItemProperty(), ((VillagerTradeItemsEntryView)this.view).getResultItemView(), ((VillagerTradeItemsEntryView)this.view).getResultItemNameLabel(), ((VillagerTradeItemsEntryView)this.view).getResultChooseButton(), ((VillagerTradeItemsEntryView)this.view).getResultEditButton(), ((VillagerTradeItemsEntryView)this.view).getResultSnbtButton(), ((VillagerTradeItemsEntryView)this.view).getResultVaultButton(), ((VillagerTradeItemsEntryView)this.view).getResultClearButton());
    }

    private void updateTitle(int index) {
        ((VillagerTradeItemsEntryView)this.view).getTradeTitleLabel().setLabel((class_2561)ModTexts.trade(index + 1));
    }

    private void bindItemControls(ObjectProperty<class_1799> property, ItemView itemView, Label nameLabel, TexturedButton chooseButton, TexturedButton editButton, TexturedButton snbtButton, TexturedButton vaultButton, TexturedButton clearButton) {
        itemView.itemProperty().bind(property);
        Runnable refresh = () -> this.updateItemDisplay((class_1799)property.getValue(), nameLabel, editButton, snbtButton);
        property.addListener(stack -> refresh.run());
        refresh.run();
        chooseButton.onAction(() -> this.openItemSelection(property, refresh));
        editButton.onAction(() -> this.openEditor(property, refresh, EditorType.STANDARD));
        snbtButton.onAction(() -> this.openEditor(property, refresh, EditorType.SNBT));
        vaultButton.onAction(() -> this.openVaultSelection(property, refresh));
        clearButton.onAction(() -> {
            property.setValue(class_1799.field_8037);
            refresh.run();
        });
    }

    private void updateItemDisplay(class_1799 stack, Label nameLabel, TexturedButton editButton, TexturedButton snbtButton) {
        class_5250 name;
        class_5250 class_52502 = name = stack.method_7960() ? class_2561.method_43470((String)"-").method_27694(style -> style.method_36139(0xA0A0A0)) : stack.method_7964().method_27661();
        if (!stack.method_7960() && stack.method_7947() > 1) {
            name.method_10852((class_2561)class_2561.method_43470((String)(" x" + stack.method_7947())).method_27692(class_124.field_1063));
        }
        nameLabel.setLabel((class_2561)name);
        this.updateItemTooltip(stack, nameLabel);
        boolean empty = stack.method_7960();
        editButton.setDisable(empty);
        snbtButton.setDisable(empty);
    }

    private void updateItemTooltip(class_1799 stack, Label label) {
        ObservableList<class_2561> tooltip = label.getTooltip();
        tooltip.clear();
        if (stack.method_7960()) {
            tooltip.add((class_2561)ModTexts.choose(ModTexts.ITEM).method_27661().method_27692(class_124.field_1080));
            return;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        tooltip.add((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1063));
        tooltip.add((class_2561)ModTexts.COUNT.method_27661().method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(stack.method_7947())).method_27692(class_124.field_1065)));
        tooltip.add((class_2561)ModTexts.OPEN_SNBT_EDITOR.method_27661().method_27692(class_124.field_1080));
    }

    private void openItemSelection(ObjectProperty<class_1799> property, Runnable afterSelection) {
        String initial = ((class_1799)property.getValue()).method_7960() ? "" : class_7923.field_41178.method_10221((Object)((class_1799)property.getValue()).method_7909()).toString();
        ModScreenHandler.openListSelectionScreen(ModTexts.ITEM, initial, ClientCache.getItemSelectionItems(), selection -> {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            try {
                class_2960 id = class_2960.method_60654((String)selection);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                if (item != null) {
                    property.setValue(new class_1799((class_1935)item));
                    afterSelection.run();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void openEditor(ObjectProperty<class_1799> property, Runnable refresher, EditorType type) {
        this.ensureItemStack(property, refresher, () -> this.openEditorNow(property, refresher, type));
    }

    private void openEditorNow(ObjectProperty<class_1799> property, Runnable refresher, EditorType type) {
        class_1799 initial = ((class_1799)property.getValue()).method_7972();
        ItemEditorContext context = new ItemEditorContext(initial, null, false, ctx -> {
            class_1799 result = ctx.getItemStack().method_7972();
            property.setValue(result);
            refresher.run();
        });
        ModScreenHandler.openEditor(type, context);
    }

    private void openVaultSelection(ObjectProperty<class_1799> property, Runnable refresher) {
        ArrayList<VaultItemListSelectionElementModel> elements = new ArrayList<VaultItemListSelectionElementModel>();
        LinkedHashMap<String, class_1799> stacksById = new LinkedHashMap<String, class_1799>();
        List<class_2487> storedItems = Vault.getInstance().getItems();
        for (int i = 0; i < storedItems.size(); ++i) {
            class_1799 stack = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)storedItems.get(i));
            if (stack.method_7960()) continue;
            class_2960 id = class_2960.method_60655((String)"cadeditor", (String)("villager_trade_vault_item_" + i));
            elements.add(new VaultItemListSelectionElementModel(id, stack));
            stacksById.put(id.toString(), stack.method_7972());
        }
        if (elements.isEmpty()) {
            return;
        }
        ModScreenHandler.openListSelectionScreen(ModTexts.VAULT, "villager_trade_vault", elements, selection -> {
            class_1799 chosen = (class_1799)stacksById.get(selection);
            if (chosen == null) {
                return;
            }
            property.setValue(chosen.method_7972());
            refresher.run();
        });
    }

    private void ensureItemStack(ObjectProperty<class_1799> property, Runnable refresher, Runnable onReady) {
        if (!((class_1799)property.getValue()).method_7960()) {
            onReady.run();
            return;
        }
        this.openItemSelection(property, () -> {
            refresher.run();
            if (!((class_1799)property.getValue()).method_7960()) {
                onReady.run();
            }
        });
    }

    @Override
    protected void resetModel() {
        super.resetModel();
        this.updateTitle(((VillagerTradeItemsEntryModel)this.model).getListIndex());
    }
}

