/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.entity;

import com.github.franckyi.guapi.api.node.TextField;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeValuesEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.entity.VillagerTradeValuesEntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class VillagerTradeValuesEntryController
extends EntryController<VillagerTradeValuesEntryModel, VillagerTradeValuesEntryView> {
    private final DecimalFormat floatFormat = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private final VillagerTradeEntryModel tradeModel;

    public VillagerTradeValuesEntryController(VillagerTradeValuesEntryModel model, VillagerTradeValuesEntryView view) {
        super(model, view);
        this.tradeModel = model.getTradeModel();
    }

    @Override
    public void bind() {
        super.bind();
        ((VillagerTradeValuesEntryView)this.view).setListButtonsVisible(false);
        this.updateTitle(((VillagerTradeValuesEntryModel)this.model).getListIndex());
        ((VillagerTradeValuesEntryModel)this.model).listIndexProperty().addListener(value -> {
            ((VillagerTradeValuesEntryView)this.view).setListButtonsVisible(false);
            this.updateTitle((int)value);
        });
        this.configureIntegerField(((VillagerTradeValuesEntryView)this.view).getMaxUsesField(), this.tradeModel::setMaxUses, 1);
        this.configureIntegerField(((VillagerTradeValuesEntryView)this.view).getUsesField(), this.tradeModel::setUses, 0);
        this.configureIntegerField(((VillagerTradeValuesEntryView)this.view).getDemandField(), this.tradeModel::setDemand, null);
        this.configureIntegerField(((VillagerTradeValuesEntryView)this.view).getSpecialPriceField(), this.tradeModel::setSpecialPrice, null);
        this.configureFloatField(((VillagerTradeValuesEntryView)this.view).getPriceMultiplierField(), this.tradeModel::setPriceMultiplier);
        this.configureIntegerField(((VillagerTradeValuesEntryView)this.view).getXpField(), this.tradeModel::setXp, 0);
        this.tradeModel.maxUsesProperty().addListener(value -> this.syncIntegerField(((VillagerTradeValuesEntryView)this.view).getMaxUsesField(), (int)value));
        this.tradeModel.usesProperty().addListener(value -> this.syncIntegerField(((VillagerTradeValuesEntryView)this.view).getUsesField(), (int)value));
        this.tradeModel.demandProperty().addListener(value -> this.syncIntegerField(((VillagerTradeValuesEntryView)this.view).getDemandField(), (int)value));
        this.tradeModel.specialPriceProperty().addListener(value -> this.syncIntegerField(((VillagerTradeValuesEntryView)this.view).getSpecialPriceField(), (int)value));
        this.tradeModel.priceMultiplierProperty().addListener(value -> this.syncFloatField(((VillagerTradeValuesEntryView)this.view).getPriceMultiplierField(), (Float)value));
        this.tradeModel.xpProperty().addListener(value -> this.syncIntegerField(((VillagerTradeValuesEntryView)this.view).getXpField(), (int)value));
        ((VillagerTradeValuesEntryView)this.view).getRewardExpBox().checkedProperty().bindBidirectional(this.tradeModel.rewardExpProperty());
        this.refreshFieldTexts();
        this.updateEditorValidity();
    }

    private void updateTitle(int index) {
        ((VillagerTradeValuesEntryView)this.view).getTradeTitleLabel().setLabel((class_2561)ModTexts.trade(index + 1));
    }

    private void configureIntegerField(TextField field, Consumer<Integer> consumer, Integer minValue) {
        field.setValidator(text -> {
            try {
                int value = Integer.parseInt(text);
                return minValue == null || value >= minValue;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        });
        field.textProperty().addListener(text -> {
            if (field.isValid()) {
                consumer.accept(Integer.parseInt(text));
            }
            this.updateEditorValidity();
        });
    }

    private void configureFloatField(TextField field, Consumer<Float> consumer) {
        field.setValidator(text -> {
            try {
                Float.parseFloat(text);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        });
        field.textProperty().addListener(text -> {
            if (field.isValid()) {
                consumer.accept(Float.valueOf(Float.parseFloat(text)));
            }
            this.updateEditorValidity();
        });
    }

    private void refreshFieldTexts() {
        ((VillagerTradeValuesEntryView)this.view).getMaxUsesField().setText(Integer.toString(this.tradeModel.getMaxUses()));
        ((VillagerTradeValuesEntryView)this.view).getUsesField().setText(Integer.toString(this.tradeModel.getUses()));
        ((VillagerTradeValuesEntryView)this.view).getDemandField().setText(Integer.toString(this.tradeModel.getDemand()));
        ((VillagerTradeValuesEntryView)this.view).getSpecialPriceField().setText(Integer.toString(this.tradeModel.getSpecialPrice()));
        ((VillagerTradeValuesEntryView)this.view).getPriceMultiplierField().setText(this.floatFormat.format(this.tradeModel.getPriceMultiplier()));
        ((VillagerTradeValuesEntryView)this.view).getXpField().setText(Integer.toString(this.tradeModel.getXp()));
    }

    private void syncIntegerField(TextField field, int value) {
        String text = Integer.toString(value);
        if (!text.equals(field.getText())) {
            field.setText(text);
        }
    }

    private void syncFloatField(TextField field, Float value) {
        String text = this.floatFormat.format(value == null ? 0.0 : (double)value.floatValue());
        if (!text.equals(field.getText())) {
            field.setText(text);
        }
    }

    private void updateEditorValidity() {
        boolean fieldsValid = ((VillagerTradeValuesEntryView)this.view).getMaxUsesField().isValid() && ((VillagerTradeValuesEntryView)this.view).getUsesField().isValid() && ((VillagerTradeValuesEntryView)this.view).getDemandField().isValid() && ((VillagerTradeValuesEntryView)this.view).getSpecialPriceField().isValid() && ((VillagerTradeValuesEntryView)this.view).getPriceMultiplierField().isValid() && ((VillagerTradeValuesEntryView)this.view).getXpField().isValid();
        this.tradeModel.setEditorFieldsValid(fieldsValid);
    }

    @Override
    protected void resetModel() {
        super.resetModel();
        this.refreshFieldTexts();
        this.updateEditorValidity();
        ((VillagerTradeValuesEntryView)this.view).setListButtonsVisible(false);
    }
}

