/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ItemContainerSlotEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.VaultItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.ItemContainerSlotEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class ItemContainerSlotEntryController
extends EntryController<ItemContainerSlotEntryModel, ItemContainerSlotEntryView> {
    public ItemContainerSlotEntryController(ItemContainerSlotEntryModel model, ItemContainerSlotEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((ItemContainerSlotEntryView)this.view).setListButtonsVisible(false);
        ((ItemContainerSlotEntryView)this.view).disableDeleteButton();
        ((ItemContainerSlotEntryView)this.view).getUpButton().setVisible(false);
        ((ItemContainerSlotEntryView)this.view).getDownButton().setVisible(false);
        ((ItemContainerSlotEntryView)this.view).getSlotLabel().setLabel(((ItemContainerSlotEntryModel)this.model).getSlotLabel());
        ((ItemContainerSlotEntryModel)this.model).listIndexProperty().addListener(value -> ((ItemContainerSlotEntryView)this.view).getSlotLabel().setLabel(((ItemContainerSlotEntryModel)this.model).getSlotLabel()));
        ((ItemContainerSlotEntryView)this.view).getItemView().itemProperty().bind(((ItemContainerSlotEntryModel)this.model).itemStackProperty());
        ((ItemContainerSlotEntryModel)this.model).itemStackProperty().addListener(stack -> this.updateItemName());
        this.updateItemName();
        ((ItemContainerSlotEntryView)this.view).getChooseItemButton().onAction(() -> this.openItemSelection(null));
        ((ItemContainerSlotEntryView)this.view).getLoadVaultButton().onAction(this::openVaultSelection);
        ((ItemContainerSlotEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((ItemContainerSlotEntryView)this.view).getOpenSnbtEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
        ((ItemContainerSlotEntryView)this.view).getClearButton().onAction(() -> {
            ((ItemContainerSlotEntryModel)this.model).setItemStack(class_1799.field_8037);
            this.updateItemName();
        });
    }

    private void updateItemName() {
        class_5250 name;
        class_1799 stack = ((ItemContainerSlotEntryModel)this.model).getItemStack();
        class_5250 class_52502 = name = stack.method_7960() ? class_2561.method_43470((String)"-").method_27694(style -> style.method_36139(0xA0A0A0)) : stack.method_7964().method_27661();
        if (!stack.method_7960() && stack.method_7947() > 1) {
            name.method_10852((class_2561)class_2561.method_43470((String)(" x" + stack.method_7947())).method_27692(class_124.field_1063));
        }
        ((ItemContainerSlotEntryView)this.view).getItemNameLabel().setLabel((class_2561)name);
        this.updateItemTooltip(stack);
        ((ItemContainerSlotEntryView)this.view).getOpenSnbtEditorButton().setDisable(stack.method_7960());
    }

    private void updateItemTooltip(class_1799 stack) {
        ObservableList<class_2561> tooltip = ((ItemContainerSlotEntryView)this.view).getItemNameLabel().getTooltip();
        tooltip.clear();
        if (stack.method_7960()) {
            tooltip.add((class_2561)ModTexts.choose(ModTexts.ITEM).method_27661().method_27692(class_124.field_1080));
            return;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        tooltip.add((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1063));
        tooltip.add((class_2561)ModTexts.COUNT.method_27661().method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(stack.method_7947())).method_27692(class_124.field_1065)));
        tooltip.add((class_2561)ModTexts.OPEN_SNBT_EDITOR.method_27661().method_27692(class_124.field_1080));
    }

    private void openItemSelection(Runnable afterSelection) {
        ModScreenHandler.openListSelectionScreen(ModTexts.ITEM, "container_slot", ClientCache.getItemSelectionItems(), selection -> {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            try {
                class_2960 id = class_2960.method_60654((String)selection);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                if (item != null) {
                    ((ItemContainerSlotEntryModel)this.model).setItemStack(new class_1799((class_1935)item));
                    this.updateItemName();
                    if (afterSelection != null) {
                        afterSelection.run();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void openEditor(EditorType type) {
        this.ensureItemStack(() -> this.openEditorNow(type));
    }

    private void openEditorNow(EditorType type) {
        class_1799 initial = ((ItemContainerSlotEntryModel)this.model).getItemStack().method_7972();
        ItemEditorContext context = new ItemEditorContext(initial, null, false, ctx -> {
            class_1799 result = ctx.getItemStack().method_7972();
            ((ItemContainerSlotEntryModel)this.model).setItemStack(result);
            this.updateItemName();
        });
        ModScreenHandler.openEditor(type, context);
    }

    private void ensureItemStack(Runnable onReady) {
        if (!((ItemContainerSlotEntryModel)this.model).getItemStack().method_7960()) {
            onReady.run();
            return;
        }
        this.openItemSelection(onReady);
    }

    private void openVaultSelection() {
        List<class_2487> storedItems = Vault.getInstance().getItems();
        if (storedItems.isEmpty()) {
            return;
        }
        ArrayList<VaultItemListSelectionElementModel> elements = new ArrayList<VaultItemListSelectionElementModel>();
        LinkedHashMap<String, class_1799> stacksById = new LinkedHashMap<String, class_1799>();
        for (int i = 0; i < storedItems.size(); ++i) {
            class_1799 stack = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)storedItems.get(i));
            if (stack.method_7960()) continue;
            class_2960 id = class_2960.method_60656((String)("inventory_vault_item_" + i));
            elements.add(new VaultItemListSelectionElementModel(id, stack));
            stacksById.put(id.toString(), stack.method_7972());
        }
        if (elements.isEmpty()) {
            return;
        }
        ModScreenHandler.openListSelectionScreen(ModTexts.VAULT, "vault_inventory_slot", elements, selected -> {
            class_1799 chosen = (class_1799)stacksById.get(selected);
            if (chosen != null) {
                ((ItemContainerSlotEntryModel)this.model).setItemStack(chosen.method_7972());
                this.updateItemName();
            }
        });
    }
}

