/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.util.Predicates;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.SelectionEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.PotionEffectEntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class PotionEffectEntryController
extends SelectionEntryController<PotionEffectEntryModel, PotionEffectEntryView> {
    private final DecimalFormat secondsFormat = new DecimalFormat("0.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public PotionEffectEntryController(PotionEffectEntryModel model, PotionEffectEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        this.updateAmplifierView();
        this.updateDurationView();
        ((PotionEffectEntryView)this.view).getAmbientBox().checkedProperty().bindBidirectional(((PotionEffectEntryModel)this.model).ambientProperty());
        ((PotionEffectEntryView)this.view).getShowParticlesBox().checkedProperty().bindBidirectional(((PotionEffectEntryModel)this.model).showParticlesProperty());
        ((PotionEffectEntryView)this.view).getShowIconBox().checkedProperty().bindBidirectional(((PotionEffectEntryModel)this.model).showIconProperty());
        ((PotionEffectEntryView)this.view).getDurationUnitToggle().activeProperty().bindBidirectional(((PotionEffectEntryModel)this.model).useSecondsProperty());
        ((PotionEffectEntryView)this.view).getDurationUnitToggle().activeProperty().addListener(this::updateDurationUnit);
        ((PotionEffectEntryView)this.view).getAmplifierField().textProperty().addListener(value -> {
            if (((PotionEffectEntryView)this.view).getAmplifierField().isValid()) {
                ((PotionEffectEntryModel)this.model).setAmplifier(Integer.parseInt(value));
            }
        });
        ((PotionEffectEntryModel)this.model).amplifierProperty().addListener(this::updateAmplifierView);
        ((PotionEffectEntryView)this.view).getDurationField().textProperty().addListener(value -> {
            if (((PotionEffectEntryView)this.view).getDurationField().isValid()) {
                if (((PotionEffectEntryModel)this.model).isUseSeconds()) {
                    ((PotionEffectEntryModel)this.model).setDuration(this.secondsToTicks(Double.parseDouble(value)));
                } else {
                    ((PotionEffectEntryModel)this.model).setDuration(Integer.parseInt(value));
                }
            }
        });
        ((PotionEffectEntryModel)this.model).durationProperty().addListener(this::updateDurationView);
        ((PotionEffectEntryView)this.view).getAmplifierField().validProperty().addListener(this::updateValidity);
        ((PotionEffectEntryView)this.view).getDurationField().validProperty().addListener(this::updateValidity);
        ((PotionEffectEntryModel)this.model).valueProperty().addListener(this::updatePreview);
        this.updateDurationUnit();
        this.updatePreview((String)((PotionEffectEntryModel)this.model).getValue());
    }

    private void updateValidity() {
        ((PotionEffectEntryModel)this.model).setValid(((PotionEffectEntryView)this.view).getAmplifierField().isValid() && ((PotionEffectEntryView)this.view).getDurationField().isValid());
    }

    private void updateAmplifierView() {
        ((PotionEffectEntryView)this.view).getAmplifierField().setText(Integer.toString(((PotionEffectEntryModel)this.model).getAmplifier()));
    }

    private void updateDurationView() {
        if (((PotionEffectEntryModel)this.model).isUseSeconds()) {
            ((PotionEffectEntryView)this.view).getDurationField().setText(this.secondsFormat.format((double)((PotionEffectEntryModel)this.model).getDuration() / 20.0));
        } else {
            ((PotionEffectEntryView)this.view).getDurationField().setText(Integer.toString(((PotionEffectEntryModel)this.model).getDuration()));
        }
    }

    private void updateDurationUnit() {
        ((PotionEffectEntryView)this.view).getDurationUnitToggle().setLabel((class_2561)(((PotionEffectEntryModel)this.model).isUseSeconds() ? ModTexts.SECONDS : ModTexts.TICKS));
        this.updateDurationValidator();
        this.updateDurationView();
    }

    private void updateDurationValidator() {
        if (((PotionEffectEntryModel)this.model).isUseSeconds()) {
            ((PotionEffectEntryView)this.view).getDurationField().setValidator(value -> {
                try {
                    return Double.parseDouble(value) > 0.0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        } else {
            ((PotionEffectEntryView)this.view).getDurationField().setValidator(Predicates.range(1, Integer.MAX_VALUE));
        }
    }

    private int secondsToTicks(double seconds) {
        return Math.max(1, (int)Math.round(seconds * 20.0));
    }

    private void updatePreview(String value) {
        class_2960 id = this.parseResourceLocation(value);
        if (id == null) {
            ((PotionEffectEntryView)this.view).setPreviewVisible(false);
            return;
        }
        ClientCache.findEffectSelectionItem(id).ifPresentOrElse(effect -> {
            ((PotionEffectEntryView)this.view).getPreviewSpriteView().setSpriteFactory(effect.getSpriteFactory());
            ((PotionEffectEntryView)this.view).getPreviewLabel().setLabel((class_2561)GuapiHelper.translated(effect.getName()).method_27692(class_124.field_1080));
            ((PotionEffectEntryView)this.view).setPreviewVisible(true);
        }, () -> ((PotionEffectEntryView)this.view).setPreviewVisible(false));
    }
}

