/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.franckyi.guapi.api.node.TextArea;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.WritableBookPagesEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.WritableBookPagesEntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class WritableBookPagesEntryController
extends EntryController<WritableBookPagesEntryModel, WritableBookPagesEntryView> {
    private boolean updating;

    public WritableBookPagesEntryController(WritableBookPagesEntryModel model, WritableBookPagesEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((WritableBookPagesEntryView)this.getView()).setListButtonsVisible(false);
        ((WritableBookPagesEntryView)this.getView()).getResetButton().setVisible(false);
        TextArea area = ((WritableBookPagesEntryView)this.getView()).getEditorArea();
        area.setValidator(this::isLengthValid);
        area.textProperty().addListener(value -> {
            if (!this.updating) {
                ((WritableBookPagesEntryModel)this.getModel()).setSelectedPage((String)value);
                this.updateStatusLabel((String)value);
            }
        });
        ((WritableBookPagesEntryView)this.getView()).getPrevButton().onAction(() -> {
            ((WritableBookPagesEntryModel)this.getModel()).selectPrevious();
            this.refresh();
        });
        ((WritableBookPagesEntryView)this.getView()).getNextButton().onAction(() -> {
            ((WritableBookPagesEntryModel)this.getModel()).selectNext();
            this.refresh();
        });
        ((WritableBookPagesEntryView)this.getView()).getAddButton().onAction(() -> {
            ((WritableBookPagesEntryModel)this.getModel()).insertAfterCurrent();
            this.refresh();
        });
        ((WritableBookPagesEntryView)this.getView()).getRemoveButton().onAction(() -> {
            ((WritableBookPagesEntryModel)this.getModel()).removeCurrent();
            this.refresh();
        });
        ((WritableBookPagesEntryModel)this.getModel()).pages().addListener(this::refresh);
        ((WritableBookPagesEntryModel)this.getModel()).selectedIndexProperty().addListener(i -> this.refresh());
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        this.updating = true;
        try {
            String text = ((WritableBookPagesEntryModel)this.getModel()).getSelectedPage();
            TextArea area = ((WritableBookPagesEntryView)this.getView()).getEditorArea();
            area.setText(text);
            int caret = text == null ? 0 : text.length();
            area.setCursorPosition(caret);
            area.setHighlightPosition(caret);
            this.updateStatusLabel(text);
            this.updateButtonStates();
        }
        finally {
            this.updating = false;
        }
    }

    private void updateStatusLabel(String value) {
        int length = value == null ? 0 : value.length();
        int remaining = 1024 - length;
        int index = ((WritableBookPagesEntryModel)this.getModel()).getSelectedIndex();
        int total = Math.max(1, ((WritableBookPagesEntryModel)this.getModel()).getPageCount());
        class_5250 status = ModTexts.gui("book_page_indicator").method_27661().method_10852((class_2561)class_2561.method_43470((String)(" " + (index + 1) + "/" + total)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" \u00b7 ").method_27692(class_124.field_1063)).method_10852((class_2561)ModTexts.gui("book_char_count").method_27661()).method_10852((class_2561)class_2561.method_43470((String)(" " + length + "/1024")).method_27692(remaining >= 0 ? class_124.field_1080 : class_124.field_1061));
        ((WritableBookPagesEntryView)this.getView()).getStatusLabel().setLabel((class_2561)status);
    }

    private void updateButtonStates() {
        int index = ((WritableBookPagesEntryModel)this.getModel()).getSelectedIndex();
        int total = ((WritableBookPagesEntryModel)this.getModel()).getPageCount();
        ((WritableBookPagesEntryView)this.getView()).getPrevButton().setDisable(index <= 0);
        ((WritableBookPagesEntryView)this.getView()).getNextButton().setDisable(index >= total - 1);
        ((WritableBookPagesEntryView)this.getView()).getRemoveButton().setDisable(total <= 1);
        ((WritableBookPagesEntryView)this.getView()).getAddButton().setDisable(total >= 100);
    }

    private boolean isLengthValid(String value) {
        return value == null || value.length() <= 1024;
    }
}

